/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.framework.launch;

// $Id: OSGiFrameworkFactory.java 94263 2009-10-02 10:21:47Z thomas.diesler@jboss.com $

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractControllerContextActions;
import org.jboss.dependency.plugins.action.ControllerContextAction;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiSystemState;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/**
 * An impementation of an OSGi FrameworkFactory
 * 
 * @author thomas.diesler@jboss.com
 * @since 21-Aug-2009
 */
public class OSGiFrameworkFactory implements FrameworkFactory
{
   // Provide logging
   final Logger log = Logger.getLogger(OSGiFrameworkFactory.class);

   @SuppressWarnings("unchecked")
   public Framework newFramework(Map configuration)
   {
      // Bootstrap the kernel
      AbstractBootstrap bootstrap = new BasicBootstrap();
      bootstrap.run();

      Kernel kernel = bootstrap.getKernel();
      KernelController controller = preinstallKernelBeans(kernel);

      BasicXMLDeployer deployer = new BasicXMLDeployer(kernel, ControllerMode.AUTOMATIC);

      URL url = null;
      String[] bootstraps = new String[] { "bootstrap/bootstrap.xml", "jboss-osgi-bootstrap.xml", "META-INF/jboss-osgi-bootstrap.xml" };
      ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
      for (String xml : bootstraps)
      {
         if (contextLoader != null)
            url = contextLoader.getResource(xml);
         
         if (url == null)
            url = getClass().getResource(xml);
         
         if (url != null)
            break;
      }
      if (url == null)
         throw new IllegalStateException("Cannot find any bootstrap: " + Arrays.asList(bootstraps));

      try
      {
         deployer.deploy(url);
      }
      catch (Throwable ex)
      {
         throw new IllegalStateException("Cannot deploy bootstrap beans", ex);
      }

      ControllerContext managerContext = controller.getInstalledContext(OSGiBundleManager.BEAN_BUNDLE_MANAGER);
      if (managerContext == null)
         throw new IllegalStateException("Cannot obtain installed bean: " + OSGiBundleManager.BEAN_BUNDLE_MANAGER);

      OSGiBundleManager manager = (OSGiBundleManager)managerContext.getTarget();
      OSGiSystemState sysBundle = (OSGiSystemState)manager.getBundleById(0);
      
      return new OSGiFramework(manager, sysBundle);
   }

   private KernelController preinstallKernelBeans(Kernel kernel)
   {
      KernelController controller = kernel.getController();
      ControllerContextActions actions = new AbstractControllerContextActions(new HashMap<ControllerState, ControllerContextAction>());
      try
      {
         controller.install(new AbstractControllerContext("jboss.kernel:service=KernelController", actions, null, controller));
         controller.install(new AbstractControllerContext("jboss.kernel:service=Kernel", actions, null, kernel));
      }
      catch (Throwable th)
      {
         throw new IllegalStateException("Cannot preinstall kernel bean", th);
      }
      return controller;
   }

}