/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.framework.service.internal;

//$Id: StartLevelImpl.java 93118 2009-09-02 08:24:44Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.spi.metadata.CapabilitiesMetaData;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleWrapper;
import org.jboss.osgi.framework.plugins.PackageAdminServicePlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractServicePluginImpl;
import org.jboss.osgi.framework.resolver.BundleResolver;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

/**
 * An implementation of the {@link PackageAdmin}.
 * 
 * [TODO] [JBOSGI-149] Fully implement PackageAdmin
 * 
 * @author thomas.diesler@jboss.com
 * @since 03-Sep-2009
 */
public class PackageAdminImpl extends AbstractServicePluginImpl implements PackageAdminServicePlugin
{
   /** The log */
   private static final Logger log = Logger.getLogger(PackageAdminImpl.class);

   private ServiceRegistration registration;

   public PackageAdminImpl(OSGiBundleManager bundleManager)
   {
      super(bundleManager);
   }

   public void startService()
   {
      BundleContext sysContext = getSystemContext();
      registration = sysContext.registerService(PackageAdmin.class.getName(), this, null);
   }

   public void stopService()
   {
      if (registration != null)
      {
         registration.unregister();
         registration = null;
      }
   }

   @SuppressWarnings("unchecked")
   public Bundle getBundle(Class clazz)
   {
      throw new NotImplementedException();
   }

   public int getBundleType(Bundle bundle)
   {
      throw new NotImplementedException();
   }

   public Bundle[] getBundles(String symbolicName, String versionRange)
   {
      throw new NotImplementedException();
   }

   public ExportedPackage getExportedPackage(String name)
   {
      throw new NotImplementedException();
   }

   public ExportedPackage[] getExportedPackages(Bundle bundle)
   {
      OSGiBundleState bundleState = assertBundleState(bundle);
      DeploymentUnit unit = bundleState.getDeploymentUnit();
      ClassLoadingMetaData metaData = unit.getAttachment(ClassLoadingMetaData.class);
      if (metaData == null)
         throw new IllegalStateException("Cannot obtain ClassLoadingMetaData");

      List<ExportedPackage> exported = new ArrayList<ExportedPackage>();
      CapabilitiesMetaData capabilities = metaData.getCapabilities();
      for (Capability capability : capabilities.getCapabilities())
      {
         if (capability instanceof PackageCapability)
         {
            exported.add(new ExportedPackageImpl(bundleState, (PackageCapability)capability));
         }
      }
      if (exported.size() == 0)
         return null;

      ExportedPackage[] result = new ExportedPackage[exported.size()];
      exported.toArray(result);

      return result;
   }

   public ExportedPackage[] getExportedPackages(String name)
   {
      throw new NotImplementedException();
   }

   public Bundle[] getFragments(Bundle bundle)
   {
      throw new NotImplementedException();
   }

   public Bundle[] getHosts(Bundle bundle)
   {
      throw new NotImplementedException();
   }

   public RequiredBundle[] getRequiredBundles(String symbolicName)
   {
      throw new NotImplementedException();
   }

   public void refreshPackages(Bundle[] bundles)
   {
      // [TODO] refreshPackages(Bundle[] bundles)
      log.debug("Ignore refreshPackages");
   }

   public boolean resolveBundles(Bundle[] bundleArr)
   {
      // Collect the bundles that are in state INSTALLED
      List<Bundle> unresolvedBundles = new ArrayList<Bundle>();
      if (bundleArr == null)
      {
         unresolvedBundles.addAll(bundleManager.getBundles(Bundle.INSTALLED));
      }
      else
      {
         for (Bundle bundle : bundleArr)
         {
            if (bundle.getState() == Bundle.INSTALLED)
               unresolvedBundles.add(bundle);
         }
      }

      if (unresolvedBundles.isEmpty())
         return true;

      BundleResolver bundleResolver = bundleManager.getBundleResolver();
      List<OSGiBundleState> resolvableBundles = bundleResolver.resolveBundles(unresolvedBundles);
      boolean allResolved = resolvableBundles.containsAll(unresolvedBundles);

      int resolved = 1;
      while (resolved > 0)
      {
         resolved = 0;
         Iterator<OSGiBundleState> it = resolvableBundles.iterator();
         while (it.hasNext())
         {
            OSGiBundleState bundleState = assertBundleState(it.next());
            if (bundleManager.resolve(bundleState, false))
            {
               it.remove();
               resolved++;
            }
         }
      }

      // Sanity check, that the controller could actually also resolve these bundles
      if (resolvableBundles.isEmpty() == false)
         throw new IllegalStateException("Controller could not resolve: " + resolvableBundles);

      return allResolved;
   }

   private OSGiBundleState assertBundleState(Bundle bundle)
   {
      if (bundle instanceof OSGiBundleWrapper)
         bundle = ((OSGiBundleWrapper)bundle).getBundleState();

      if (bundle instanceof OSGiBundleState == false)
         throw new IllegalArgumentException("Cannot obtain bunde state from: " + bundle);

      return (OSGiBundleState)bundle;
   }

   private static class ExportedPackageImpl implements ExportedPackage
   {
      private Bundle bundle;
      private PackageCapability capability;

      public ExportedPackageImpl(AbstractBundleState bundle, PackageCapability capability)
      {
         this.bundle = bundle.getBundle();
         this.capability = capability;
      }

      public Bundle getExportingBundle()
      {
         return bundle;
      }

      public Bundle[] getImportingBundles()
      {
         throw new NotImplementedException();
      }

      public String getName()
      {
         return capability.getName();
      }

      @SuppressWarnings("deprecation")
      public String getSpecificationVersion()
      {
         throw new NotImplementedException();
      }

      public Version getVersion()
      {
         return Version.parseVersion(capability.getVersion().toString());
      }

      public boolean isRemovalPending()
      {
         throw new NotImplementedException();
      }
   }
}