/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.osgi.classloader.test;

import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.test.osgi.OSGiTestCase;
import org.jboss.test.osgi.classloader.support.a.A;
import org.jboss.test.osgi.classloader.support.b.B;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/**
 * RequireBundleUnitTestCase.
 *
 * TODO test security
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class RequireBundleUnitTestCase extends OSGiTestCase
{
   public RequireBundleUnitTestCase(String name)
   {
      super(name);
   }

   public void testSimpleRequireBundle() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("simplerequirebundleA", "/bundles/classloader/simplerequirebundleA", B.class);
         try
         {
            bundle2.start();
            assertLoadClass(bundle2, A.class, bundle1);
            assertLoadClass(bundle2, B.class, bundle2);
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testSimpleRequireBundleFails() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("simplerequirebundlefails", "/bundles/classloader/simplerequirebundlefails", B.class);
         try
         {
            bundle2.start();
            fail("Should not be here!");
         }
         catch (BundleException ex)
         {
            // expected
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testVersionRequireBundle() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("versionrequirebundleA", "/bundles/classloader/versionrequirebundleA", B.class);
         try
         {
            bundle2.start();
            assertLoadClass(bundle2, A.class, bundle1);
            assertLoadClass(bundle2, B.class, bundle2);
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testVersionRequireBundleFails() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("versionrequirebundlefails", "/bundles/classloader/versionrequirebundlefails", B.class);
         try
         {
            bundle2.start();
            fail("Should not be here!");
         }
         catch (RuntimeException rte)
         {
            // expected
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testOptionalRequireBundle() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("optionalrequirebundleA", "/bundles/classloader/optionalrequirebundleA", B.class);
         try
         {
            bundle2.start();
            assertLoadClass(bundle2, A.class, bundle1);
            assertLoadClass(bundle2, B.class, bundle2);
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testOptionalRequireBundleFails() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("optionalrequirebundlefails", "/bundles/classloader/optionalrequirebundlefails", B.class);
         try
         {
            bundle2.start();
            assertLoadClassFail(bundle2, A.class);
            assertLoadClass(bundle2, B.class);
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testReExportRequireBundle() throws Exception
   {
      //Bundle-Name: BundleA
      //Bundle-Version: 1.0.0
      //Bundle-SymbolicName: org.jboss.test.osgi.classloader.bundleA;test=x
      //Export-Package: org.jboss.test.osgi.classloader.support.a;version=1.0.0;test=x
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         
         //Bundle-Name: BundleB
         //Bundle-SymbolicName: org.jboss.test.osgi.classloader.bundleB
         //Require-Bundle: org.jboss.test.osgi.classloader.bundleA;visibility:=reexport
         //Export-Package: org.jboss.test.osgi.classloader.support.b
         Bundle bundle2 = assembleBundle("reexportrequirebundleA", "/bundles/classloader/reexportrequirebundleA", B.class);
         
         try
         {
            bundle2.start();
            assertLoadClass(bundle2, A.class, bundle1);
            assertLoadClass(bundle2, B.class, bundle2);
            
            //Bundle-Name: BundleC
            //Bundle-SymbolicName: org.jboss.test.osgi.classloader.bundleC
            //Require-Bundle: org.jboss.test.osgi.classloader.bundleB
            Bundle bundle3 = assembleBundle("reexportrequirebundleB", "/bundles/classloader/reexportrequirebundleB");
            
            try
            {
               assertLoadClass(bundle3, A.class, bundle1);
               assertLoadClass(bundle3, B.class, bundle2);
            }
            finally
            {
               uninstall(bundle3);
            }
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testNoReExportRequireBundle() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("noreexportrequirebundleA", "/bundles/classloader/noreexportrequirebundleA", B.class);
         try
         {
            bundle2.start();
            assertLoadClass(bundle2, A.class, bundle1);
            assertLoadClass(bundle2, B.class, bundle2);
            Bundle bundle3 = assembleBundle("reexportrequirebundleB", "/bundles/classloader/reexportrequirebundleB");
            try
            {
               assertLoadClassFail(bundle3, A.class);
               assertLoadClass(bundle3, B.class, bundle2);
            }
            finally
            {
               uninstall(bundle3);
            }
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testAttributeRequireBundle() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("attributerequirebundleA", "/bundles/classloader/attributerequirebundleA", B.class);
         try
         {
            bundle2.start();
            assertLoadClass(bundle2, A.class, bundle1);
            assertLoadClass(bundle2, B.class, bundle2);
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
   
   public void testAttributeRequireBundleFails() throws Exception
   {
      Bundle bundle1 = assembleBundle("bundleA", "/bundles/classloader/bundleA", A.class);
      try
      {
         bundle1.start();
         assertLoadClass(bundle1, A.class);
         Bundle bundle2 = assembleBundle("attributerequirebundlefails", "/bundles/classloader/attributerequirebundlefails", B.class);
         try
         {
            bundle2.start();
            fail("Should not be here!");
         }
         catch (RuntimeException rte)
         {
            // expected
         }
         finally
         {
            uninstall(bundle2);
         }
      }
      finally
      {
         uninstall(bundle1);
      }
   }
}
