/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.osgi.filter.test;

import java.util.Dictionary;

import junit.framework.Test;

import org.jboss.test.osgi.OSGiTestDelegate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/**
 * BundleContextFilterUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class BundleContextFilterUnitTestCase extends AbstractFilterTest
{
   static BundleContext bundleContext;
   
   public BundleContextFilterUnitTestCase(String name)
   {
      super(name);
   }

   public static void deployBundles(OSGiTestDelegate delegate) throws Exception
   {
      Bundle bundle = delegate.addBundle("/bundles/simple/", "simple-bundle1");
      bundle.start();
      bundleContext = bundle.getBundleContext();
   }

   protected void assertFilter(String filter, PropertyBuilder properties, boolean expected) throws Exception
   {
      super.assertFilter(filter, properties, expected);
      
      Dictionary<String, Object> dictionary = properties.getDictionary();
      ServiceRegistration registration = bundleContext.registerService(BundleContext.class.getName(), bundleContext, dictionary);
      try
      {
         ServiceReference reference = registration.getReference();
         boolean result = createFilter(filter).match(reference);
         getLog().debug(filter + " with service reference " + dictionary + " result=" + result);
         if (expected)
            assertTrue("Expected " + filter + " to match with service reference properties " + dictionary, result);
         else
            assertFalse("Expected " + filter + " to NOT match with service reference properties " + dictionary, result);
         
         if (expected)
         {
            assertAllReferences(bundleContext, BundleContext.class.getName(), filter, reference);
            assertReferences(bundleContext, BundleContext.class.getName(), filter, reference);
         }
      }
      finally
      {
         registration.unregister();
      }
   }

   protected void assertFilterCaseSensitive(String filter, PropertyBuilder properties, boolean expected) throws Exception
   {
      assertFilter(createFilter(filter), properties, expected, true);
   }

   protected Filter createFilter(String filter) throws Exception
   {
      return bundleContext.createFilter(filter);
   }
}
