/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.resolver;

// $Id: FrameworkLaunchTestCase.java 92733 2009-08-24 09:40:32Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.resolver.BundleResolver;
import org.jboss.osgi.spi.testing.OSGiTest;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/**
 * Test OSGi System bundle access
 * 
 * @author thomas.diesler@jboss.com
 * @since 27-Jul-2009
 */
public class BundleResolverTest extends OSGiTest
{
   @Test
   public void testBundleResolver() throws BundleException
   {
      FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
      Framework framework = factory.newFramework(null);
      framework.start();

      List<String> bundlePaths = new ArrayList<String>();
      bundlePaths.add("bundles/jboss-osgi-apache-xerces.jar");
      bundlePaths.add("bundles/jboss-osgi-common.jar");
      bundlePaths.add("bundles/jboss-osgi-common-core.jar");
      bundlePaths.add("bundles/jboss-osgi-husky.jar");
      bundlePaths.add("bundles/jboss-osgi-jaxb.jar");
      bundlePaths.add("bundles/jboss-osgi-jmx.jar");
      bundlePaths.add("bundles/jboss-osgi-jndi.jar");
      bundlePaths.add("bundles/jboss-osgi-xml-binding.jar");
      bundlePaths.add("bundles/org.apache.felix.configadmin.jar");
      //bundlePaths.add("bundles/org.apache.felix.http.jetty.jar");
      bundlePaths.add("bundles/org.apache.felix.log.jar");
      bundlePaths.add("bundles/org.apache.felix.metatype.jar");
      bundlePaths.add("bundles/org.osgi.compendium.jar");
      
      Collections.shuffle(bundlePaths);
      
      List<Bundle> unresolved = new ArrayList<Bundle>();
      BundleContext sysContext = framework.getBundleContext();
      for (String path : bundlePaths)
      {
         Bundle bundle = sysContext.installBundle(getTestArchivePath(path));
         unresolved.add(bundle);
      }
      
      BundleResolver bundleResolver = new BundleResolver(null);
      List<OSGiBundleState> resolved = bundleResolver.resolveBundles(unresolved);
      assertEquals("All bundles resolved", unresolved.size(), resolved.size());
      
      framework.stop();
   }
}