/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.api;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

// $Id: $

/**
 * Frameworks must adhere to the following rules for class or resource loading.
 * When a bundle’s class loader is requested to load a class or find a
 * resource, the search must be performed in the following order:
 * 
 * 1 If the class or resource is in a java.* package, the request is delegated to
 *   the parent class loader; otherwise, the search continues with the next
 *   step. If the request is delegated to the parent class loader and the class or
 *   resource is not found, then the search terminates and the request fails.
 *   
 * 2 If the class or resource is from a package included in the boot delegation
 *   list (org.osgi.framework.bootdelegation), then the request is delegated
 *   to the parent class loader. If the class or resource is found there, the
 *   search ends.
 *   
 * 3 If the class or resource is in a package that is imported using Import-
 *   Package or was imported dynamically in a previous load, then the
 *   request is delegated to the exporting bundle’s class loader; otherwise the
 *   search continues with the next step. If the request is delegated to an
 *   exporting class loader and the class or resource is not found, then the
 *   search terminates and the request fails.
 *   
 * 4 If the class or resource is in a package that is imported from one or more
 *   other bundles using Require-Bundle, the request is delegated to the class
 *   loaders of the other bundles, in the order in which they are specified in
 *   this bundle’s manifest. This entails a depth-first strategy; all required
 *   bundles are searched before the bundle classpath is used. If the class or
 *   resource is not found, then the search continues with the next step.
 *   
 * 5 The bundle’s own internal bundle class path is searched. If the class or
 *   resource is not found, then the search continues with the next step.
 * 
 * 6 Each attached fragment’s internal bundle class path is searched. The fragments
 *   are searched in ascending bundle ID order. If the class or resource
 *   is not found, then the search continues with the next step.
 *   
 * 7 If the class or resource is in a package that is exported by the bundle or
 *   the package is imported by the bundle (using Import-Package or Require-
 *   Bundle), then the search ends and the class or resource is not found.
 *   
 * 8 Otherwise, if the class or resource is in a package that is imported using
 *   DynamicImport-Package, then a dynamic import of the package is now
 *   attempted. An exporter must conform to any implied package constraints.
 *   If an appropriate exporter is found, a wire is established so that
 *   future loads of the package are handled in Step 3. If a dynamic wire is not
 *   established, then the request fails.
 * 
 * 9 If the dynamic import of the package is established, the request is delegated
 *   to the exporting bundle’s class loader. If the request is delegated to
 *   an exporting class loader and the class or resource is not found, then the
 *   search terminates and the request fails.
 *   
 * When delegating to another bundle class loader, the delegated request
 * enters this algorithm at Step 4.
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public interface RuntimeClassLoader 
{
   Class<?> loadClass(String name) throws ClassNotFoundException;

   URL getResource(String name);

   Enumeration<URL> getResources(String name) throws IOException;
}