/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.api;

//$Id: $

import java.util.Dictionary;

import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/**
 * An abstraction of a service registry.
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public interface ServiceRegistryPlugin extends AbstractPlugin
{
   ServiceRegistration registerService(Bundle bundle, String[] clazzes, Object service, Dictionary<String, Object> properties);
   
   ServiceRegistration registerService(Bundle bundle, String clazz, Object service, Dictionary<String, Object> properties);

   void unregisterService(ServiceRegistration registration);

   ServiceReference getServiceReference(String clazz);

   ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException;

   Object getService(Bundle bundle, ServiceReference sref);

   boolean ungetService(Bundle bundle, ServiceReference reference);
}