/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework;

//$Id: $

import java.util.Dictionary;

import org.jboss.logging.Logger;
import org.jboss.osgi.jbossmc.api.ServiceRegistryPlugin;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/**
 * A simple implementation of a ServiceRegistration
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class ServiceRegistrationImpl implements ServiceRegistration
{
   // Provide logging
   final Logger log = Logger.getLogger(ServiceRegistrationImpl.class);

   private ServiceRegistryPlugin serviceRegistry;
   private ServiceReferenceImpl serviceRef;

   public ServiceRegistrationImpl(ServiceRegistryPlugin serviceRegistry, ServiceReferenceImpl serviceRef)
   {
      this.serviceRegistry = serviceRegistry;
      this.serviceRef = serviceRef;
      serviceRef.setServiceRegistration(this);
   }

   public ServiceReference getReference()
   {
      return serviceRef;
   }

   @SuppressWarnings("unchecked")
   public void setProperties(Dictionary properties)
   {
      // [TODO] ServiceRegistration.setProperties(Dictionary properties)
      throw new NotImplementedException();
   }

   public void unregister()
   {
      serviceRegistry.unregisterService(this);
   }
}