/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.classloading;

//$Id: $

import org.jboss.logging.Logger;
import org.jboss.osgi.jbossmc.api.BundleResolverPlugin;
import org.jboss.osgi.jbossmc.framework.BundleImpl;
import org.jboss.osgi.jbossmc.framework.plugins.AbstractPluginImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

/**
 * A simple implementation of a BundleResolver
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class BundleResolverPluginImpl extends AbstractPluginImpl implements BundleResolverPlugin
{
   // Provide logging
   final Logger log = Logger.getLogger(BundleResolverPluginImpl.class);
   
   public BundleResolverPluginImpl()
   {
   }

   public BundleResolverPluginImpl(Framework framework)
   {
      setFramework(framework);
   }

   public void resolveBundle(Bundle bundle) throws BundleException
   {
      // [TODO] resolve bundle properly
      
      BundleImpl bundleImpl = (BundleImpl)bundle;
      
      bundleImpl.setState(Bundle.RESOLVED);
   }
}