/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.classloading;

//$Id: BundleLifecycleImpl.java 92578 2009-08-19 14:33:04Z thomas.diesler@jboss.com $

import org.jboss.osgi.jbossmc.api.ClassLoaderFactoryPlugin;
import org.jboss.osgi.jbossmc.api.RuntimeClassLoader;
import org.jboss.osgi.jbossmc.framework.plugins.AbstractPluginImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

/**
 * An implementation of bundle class loader factory
 * 
 * @author thomas.diesler@jboss.com
 * @since 29-Jul-2009
 */
public class ClassLoaderFactoryPluginImpl extends AbstractPluginImpl implements ClassLoaderFactoryPlugin
{
   public ClassLoaderFactoryPluginImpl()
   {
   }

   public ClassLoaderFactoryPluginImpl(Framework framework)
   {
      setFramework(framework);
   }

   public RuntimeClassLoader createClassLoader(Bundle bundle)
   {
      return new RuntimeClassLoaderImpl(getFramework(), bundle);
   }
}