/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.launch;

//$Id: FrameworkFactoryBean.java 92613 2009-08-20 16:35:19Z thomas.diesler@jboss.com $

import java.util.List;
import java.util.Map;

import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.osgi.jbossmc.api.AbstractPlugin;
import org.jboss.osgi.jbossmc.framework.FrameworkImpl;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/**
 * An implementation of a bootstrap bean that can provide an OSGi Framework. 
 * 
 * @author thomas.diesler@jboss.com
 * @since 29-Jul-2009
 */
public class FrameworkFactoryBean implements FrameworkFactory
{
   // Provide logging
   final Logger log = Logger.getLogger(FrameworkFactoryBean.class);

   public static final String BEAN_FRAMEWORK_FACTORY = "jboss.osgi:service=FrameworkFactory";
   
   private Map<String, Object> properties;
   private List<AbstractPlugin> plugins;
   private Kernel kernel;

   private Framework framework;
   
   public void setProperties(Map<String, Object> properties)
   {
      this.properties = properties;
   }

   public void setPlugins(List<AbstractPlugin> plugins)
   {
      this.plugins = plugins;
   }

   public void setKernel(Kernel kernel)
   {
      this.kernel = kernel;
   }

   @SuppressWarnings("unchecked")
   public Framework newFramework(Map configuration)
   {
      if (framework == null)
      {
         if (properties == null)
            throw new IllegalStateException("Cannot obtain framework properties");
         
         if (configuration != null)
            properties.putAll(configuration);
         
         FrameworkImpl frameworkImpl = new FrameworkImpl(kernel, properties);
         
         // Copy the configured plugins
         if (plugins != null)
         {
            for (AbstractPlugin plugin : plugins)
            {
               plugin.setFramework(frameworkImpl);
               frameworkImpl.addPlugin(plugin);
            }
         }
         
         framework = frameworkImpl;
      }
      return framework;
   }
}