/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.launch;

//$Id: FrameworkFactoryImpl.java 92613 2009-08-20 16:35:19Z thomas.diesler@jboss.com $

import java.net.URL;
import java.util.Map;

import org.jboss.bootstrap.impl.mc.config.BasicMCServerConfig;
import org.jboss.bootstrap.impl.mc.server.MCServerImpl;
import org.jboss.bootstrap.spi.mc.config.MCServerConfig;
import org.jboss.bootstrap.spi.mc.server.MCServer;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.logging.Logger;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/**
 * An implementation of an OSGi FrameworkFactory
 * 
 * @author thomas.diesler@jboss.com
 * @since 29-Jul-2009
 */
public class FrameworkFactoryImpl implements FrameworkFactory
{
   // Provide logging
   final Logger log = Logger.getLogger(FrameworkFactoryImpl.class);

   private static final String BOOTSTRAP_NAME = "jboss-osgi-bootstrap.xml";
   
   @SuppressWarnings("unchecked")
   public Framework newFramework(Map configuration)
   {
      // Create a configuration
      MCServerConfig config = new BasicMCServerConfig();
      config.bootstrapHome(getBootstrapHome());
      config.bootstrapName(BOOTSTRAP_NAME);
      
      // Create the server
      final MCServer server = new MCServerImpl(config);
      try
      {
         server.start();
      }
      catch (RuntimeException rte)
      {
         throw rte;
      }
      catch (Exception ex)
      {
         throw new IllegalStateException("Cannot bootstrap MC server", ex);
      }

      ControllerContext context = server.getKernel().getController().getInstalledContext(FrameworkFactoryBean.BEAN_FRAMEWORK_FACTORY);
      if (context == null)
         throw new IllegalStateException("Cannot obtain: " + FrameworkFactoryBean.BEAN_FRAMEWORK_FACTORY);
      
      FrameworkFactory frameworkBootstrap =  (FrameworkFactory)context.getTarget();
      return frameworkBootstrap.newFramework(configuration);
   }
   
   private String getBootstrapHome()
   {
      String bootstrapHome = null;
      URL homeUrl = getBootstrapUrl();
      if (homeUrl != null)
      {
         String path = homeUrl.toExternalForm();
         bootstrapHome = path.substring(0, path.lastIndexOf('/'));
      }
      return bootstrapHome;
   }
   
   private URL getBootstrapUrl()
   {
      ClassLoader cl = getClass().getClassLoader();
      return cl.getResource("META-INF/" + BOOTSTRAP_NAME);
   }
}