/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.plugins;

//$Id: $

import java.util.ArrayList;
import java.util.List;

import org.jboss.logging.Logger;
import org.jboss.osgi.jbossmc.api.BundleEventsPlugin;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.launch.Framework;

/**
 * A simple implementation of a BundleEventManager
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class BundleEventsPluginImpl extends AbstractPluginImpl implements BundleEventsPlugin
{
   // Provide logging
   final Logger log = Logger.getLogger(BundleEventsPluginImpl.class);
   
   private List<BundleListener> listeners = new ArrayList<BundleListener>();
   private boolean enabled;

   public BundleEventsPluginImpl()
   {
   }

   public BundleEventsPluginImpl(Framework framework)
   {
      setFramework(framework);
   }

   public boolean isEnabled()
   {
      return enabled;
   }

   public void setEnabled(boolean enabled)
   {
      this.enabled = enabled;
   }

   public void fireBundleEvent(BundleEvent event)
   {
      if (enabled == false)
         return;
      
      String typeStr = ConstantsHelper.bundleEvent(event.getType());
      log.debug("BundleEvent " + typeStr + " " + event.getSource());
      
      // [TODO] When a BundleEvent is fired, it is asynchronously delivered to a BundleListener
      
      for (BundleListener listener : new ArrayList<BundleListener>(listeners))
         listener.bundleChanged(event);
   }

   public void addBundleListener(BundleListener listener)
   {
      listeners.add(listener);
   }

   public void removeBundleListener(BundleListener listener)
   {
      listeners.remove(listener);
   }
}