/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.plugins;

//$Id: $

import java.io.IOException;
import java.net.URL;

import org.jboss.logging.Logger;
import org.jboss.osgi.jbossmc.api.BundleFactoryPlugin;
import org.jboss.osgi.jbossmc.framework.BundleContextImpl;
import org.jboss.osgi.jbossmc.framework.BundleImpl;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

/**
 * A simple implementation of a BundleFactory
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class BundleFactoryPluginImpl extends AbstractPluginImpl implements BundleFactoryPlugin
{
   // Provide logging
   final Logger log = Logger.getLogger(BundleFactoryPluginImpl.class);
   
   public BundleFactoryPluginImpl()
   {
   }

   public BundleFactoryPluginImpl(Framework framework)
   {
      setFramework(framework);
   }

   public Bundle createBundle(String location)
   {
      VirtualFile vfsRoot = getVirtualFile(location);
      BundleImpl bundle = new BundleImpl(vfsRoot);
      bundle.setBundleContext(new BundleContextImpl(getFramework(), bundle));
      return bundle;
   }

   public String getVirtualLocation(String location)
   {
      try
      {
         VirtualFile vFile = getVirtualFile(location);
         URL locationURL = vFile.toURL();
         return locationURL.toExternalForm();
      }
      catch (Exception ex)
      {
         throw new IllegalStateException("Cannot obtain virtual bundle location", ex);
      }
   }
   
   public VirtualFile getVirtualFile(String location)
   {
      VirtualFile vfsRoot;
      try
      {
         URL locationURL = new URL(location);
         vfsRoot = VFS.createNewRoot(locationURL);
      }
      catch (IOException ex)
      {
         throw new IllegalArgumentException("Invalid bundle location URL: " + location);
      }
      return vfsRoot;
   }
}