/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.plugins;

//$Id: $

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.jboss.logging.Logger;
import org.jboss.osgi.jbossmc.api.BundleRegistryPlugin;
import org.jboss.osgi.jbossmc.framework.BundleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

/**
 * A simple implementation of a BundleRegistry
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class BundleRegistryPluginImpl extends AbstractPluginImpl implements BundleRegistryPlugin
{
   // Provide logging
   final Logger log = Logger.getLogger(BundleRegistryPluginImpl.class);
   
   private long globalId;
   private Map<String, Bundle> registry = new LinkedHashMap<String, Bundle>();

   public BundleRegistryPluginImpl()
   {
   }

   public BundleRegistryPluginImpl(Framework framework)
   {
      setFramework(framework);
   }

   public long registerBundle(Bundle bundle)
   {
      if (bundle == null)
         throw new IllegalArgumentException("Cannot install null bundle");
      
      BundleImpl bundleImpl = (BundleImpl)bundle;
      bundleImpl.setBundleId(globalId++);
      
      registry.put(bundle.getLocation(), bundle);
      
      long bundleId = bundle.getBundleId();
      return bundleId;
   }

   public void unregisterBundle(Bundle bundle)
   {
      if (bundle == null)
         throw new IllegalArgumentException("Cannot uninstall null bundle");
      
      if (registry.remove(bundle.getLocation()) == null)
         throw new IllegalStateException("Cannot unregister bundle: " + bundle);
   }

   public Bundle getBundleById(long id)
   {
      Bundle bundle = null;
      for (Bundle aux : new ArrayList<Bundle>(registry.values()))
      {
         if (id == aux.getBundleId())
         {
            bundle = aux;
            break;
         }
      }
      return bundle;
   }

   public Bundle getBundleByLocation(String location)
   {
      return registry.get(location);
   }

   public List<Bundle> getBundles()
   {
      ArrayList<Bundle> bundles = new ArrayList<Bundle>(registry.values());
      return Collections.unmodifiableList(bundles);
   }
}