/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jbossmc.framework.plugins;

//$Id: $

import java.util.ArrayList;
import java.util.List;

import org.jboss.logging.Logger;
import org.jboss.osgi.jbossmc.api.FrameworkEventsPlugin;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;

/**
 * A simple implementation of a FrameworkEventManager
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class FrameworkEventsPluginImpl extends AbstractPluginImpl implements FrameworkEventsPlugin
{
   // Provide logging
   final Logger log = Logger.getLogger(FrameworkEventsPluginImpl.class);
   
   private List<FrameworkListener> listeners = new ArrayList<FrameworkListener>();
   private boolean enabled;

   public FrameworkEventsPluginImpl()
   {
   }

   public FrameworkEventsPluginImpl(Framework framework)
   {
      setFramework(framework);
   }

   public boolean isEnabled()
   {
      return enabled;
   }

   public void setEnabled(boolean enabled)
   {
      this.enabled = enabled;
   }

   public void fireFrameworkEvent(FrameworkEvent event)
   {
      if (enabled == false)
         return;
      
      String typeStr = ConstantsHelper.frameworkEvent(event.getType());
      String message = "FrameworkEvent " + typeStr + " " + event.getSource();
      
      if (event.getType() == FrameworkEvent.ERROR)
         log.error(message);
      else if (event.getType() == FrameworkEvent.WARNING)
         log.warn(message);
      else if (event.getType() == FrameworkEvent.INFO)
         log.info(message);
      else
         log.debug(message);
      
      // [TODO] When a FrameworkEvent is fired, it is asynchronously delivered to a FrameworkListener.
      
      for (FrameworkListener listener : new ArrayList<FrameworkListener>(listeners))
         listener.frameworkEvent(event);
   }

   public void addFrameworkListener(FrameworkListener listener)
   {
      listeners.add(listener);
   }

   public void removeFrameworkListener(FrameworkListener listener)
   {
      listeners.remove(listener);
   }
}