/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.jbossmc;

//$Id: FrameworkLaunchTestCase.java 91789 2009-07-29 20:49:03Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertNotNull;

import org.jboss.osgi.spi.util.ServiceLoader;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/**
 * Test OSGi System bundle context
 * 
 * @author thomas.diesler@jboss.com
 * @since 27-Jul-2009
 */
public class SystemContextTestCase
{
   private static Framework framework;
   private static BundleContext context;

   @BeforeClass
   public static void beforeClass() throws BundleException
   {
      FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
      framework = factory.newFramework(null);
      framework.start();

      context = framework.getBundleContext();
      assertNotNull("System context not null", context);
   }

   @AfterClass
   public static void afterClass() throws BundleException
   {
      framework.stop();
   }

   @Test
   public void testCreateFilter() throws InvalidSyntaxException
   {
      Filter filter = context.createFilter("(foo=bar)");
      assertNotNull("Filter not null", filter);
   }
}