/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.jbossmc.simple;

//$Id: SimpleTestCase.java 91196 2009-07-14 09:41:15Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.net.URL;
import java.util.Enumeration;

import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.jboss.osgi.spi.util.ServiceLoader;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

/**
 * Install a bundle and verifies its entries
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class BundleEntriesTestCase 
{
   private static Framework framework;
   private static Bundle bundle;
   
   /*
    * /META-INF/
    * /META-INF/MANIFEST.MF
    * /org/
    * /org/jboss/
    * /org/jboss/test/
    * /org/jboss/test/osgi/
    * /org/jboss/test/osgi/jbossmc/
    * /org/jboss/test/osgi/jbossmc/simple/
    * /org/jboss/test/osgi/jbossmc/simple/bundle/
    * /org/jboss/test/osgi/jbossmc/simple/bundle/SimpleActivator.class
    * /org/jboss/test/osgi/jbossmc/simple/bundle/SimpleService.class
    */
   
   @BeforeClass
   public static void beforeClass() throws BundleException
   {
      FrameworkFactory factory = ServiceLoader.loadService(FrameworkFactory.class);
      framework = factory.newFramework(null);
      framework.start();
      
      BundleContext sysContext = framework.getBundleContext();
      URL bundleURL = new OSGiTestHelper().getTestArchiveURL("simple-bundle.jar");
      bundle = sysContext.installBundle(bundleURL.toExternalForm());
   }
   
   @AfterClass
   public static void afterClass() throws BundleException
   {
      framework.stop();
   }
   
   @Test
   public void testGetEntryPaths() throws Exception
   {
      String path = "/";
      assertEquals(11, countEntryPaths(bundle.getEntryPaths(path)));

      path = "META-INF";
      assertEquals(1, countEntryPaths(bundle.getEntryPaths(path)));

      path = "org/jboss/test/osgi/jbossmc/simple/bundle";
      assertEquals(2, countEntryPaths(bundle.getEntryPaths(path)));
      
      //bundle.uninstall();
   }

   @SuppressWarnings("unchecked")
   @Test
   public void testFindEntries() throws Exception
   {
      Enumeration entries = bundle.findEntries("META-INF", "M*.*", false);
      assertTrue("One entry", entries.hasMoreElements());
      URL entryURL = (URL)entries.nextElement();
      assertTrue("Ends with MANIFEST.MF", entryURL.toExternalForm().endsWith("simple-bundle.jar/META-INF/MANIFEST.MF"));
      
      //bundle.uninstall();
   }

   @SuppressWarnings("unchecked")
   private int countEntryPaths(Enumeration entries)
   {
      int count = 0;
      while (entries.hasMoreElements())
      {
         entries.nextElement();
         count++;
      }
      return count;
   }
   
   @SuppressWarnings({ "unused", "unchecked" })
   private void printEntryPaths(Enumeration entries)
   {
      while (entries.hasMoreElements())
         System.out.println(entries.nextElement());
   }
}