/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.jbossmc.simple;

//$Id: SimpleTestCase.java 91196 2009-07-14 09:41:15Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;

import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/**
 * A test that deployes a bundle and verifies its state
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Aug-2009
 */
public class BundleInstallTestCase
{
   private static OSGiRuntime runtime;
   
   @BeforeClass
   public static void beforeClass() throws BundleException
   {
      runtime = new OSGiTestHelper().getEmbeddedRuntime();
   }
   
   @AfterClass
   public static void afterClass() throws BundleException
   {
      if (runtime != null)
         runtime.shutdown();
   }
   
   @Test
   public void testBundleInstall() throws Exception
   {
      OSGiBundle bundle = runtime.installBundle("simple-bundle.jar");

      assertEquals("simple-bundle", bundle.getSymbolicName());
      
      bundle.start();
      assertEquals("Bundle state", Bundle.ACTIVE, bundle.getState());
      
      bundle.uninstall();
      assertEquals("Bundle state", Bundle.UNINSTALLED, bundle.getState());
   }
}