/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.example.http;

//$Id: $

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

import org.jboss.osgi.spi.capability.HttpServiceCapability;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.OSGiServiceReference;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.service.http.HttpService;

/**
 * A test that deployes a bundle that containes a HttpServlet which is registered through the OSGi HttpService
 * 
 * @author thomas.diesler@jboss.com
 * @since 23-Jan-2009
 */
public class HttpServiceTestCase
{
   private static OSGiRuntime runtime;

   @BeforeClass
   public static void setUpClass() throws Exception
   {
      runtime = new OSGiTestHelper().getDefaultRuntime();
      runtime.addCapability(new HttpServiceCapability());

      // Allow 10s for the HttpService to become available
      long timeout = 50;
      OSGiServiceReference sref = runtime.getServiceReference(HttpService.class.getName());
      while (sref == null &&  0 < timeout--)
      {
         Thread.sleep(200);
         sref = runtime.getServiceReference(HttpService.class.getName());
      }

      assertNotNull("HttpService not null", sref);

      OSGiBundle bundle = runtime.installBundle("example-http.jar");
      bundle.start();
   }

   @AfterClass
   public static void tearDownClass() throws Exception
   {
      runtime.shutdown();
   }

   @Test
   public void testServletAccess() throws Exception
   {
      URL url = new URL("http://" + runtime.getServerHost() + ":8090/servlet?test=plain");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      assertEquals("Hello from Servlet", br.readLine());
   }

   @Test
   public void testServletInitProps() throws Exception
   {
      URL url = new URL("http://" + runtime.getServerHost() + ":8090/servlet?test=initProp");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      assertEquals("initProp=SomeValue", br.readLine());
   }

   @Test
   public void testServletBundleContext() throws Exception
   {
      URL url = new URL("http://" + runtime.getServerHost() + ":8090/servlet?test=context");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      assertEquals("example-http", br.readLine());
   }

   @Test
   public void testServletStartLevel() throws Exception
   {
      URL url = new URL("http://" + runtime.getServerHost() + ":8090/servlet?test=startLevel");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      assertEquals("startLevel=1", br.readLine());
   }

   @Test
   public void testResourceAccess() throws Exception
   {
      URL url = new URL("http://" + runtime.getServerHost() + ":8090/file/message.txt");
      BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
      assertEquals("Hello from Resource", br.readLine());
   }
}