/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.example.webapp;

//$Id:$

import static org.junit.Assert.assertEquals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

import org.jboss.osgi.spi.capability.WebAppCapability;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.OSGiTest;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * A test that deployes a WAR bundle 
 * 
 * @author thomas.diesler@jboss.com
 * @since 06-Oct-2009
 */
public class WebAppTestCase extends OSGiTest
{
   private static OSGiRuntime runtime;

   @BeforeClass
   public static void setUpClass() throws Exception
   {
      OSGiTestHelper osgiTestHelper = new OSGiTestHelper();

      runtime = osgiTestHelper.getDefaultRuntime();
      runtime.addCapability(new WebAppCapability());

      OSGiBundle bundle = runtime.installBundle("example-webapp.war");
      bundle.start();
   }

   @AfterClass
   public static void tearDownClass() throws Exception
   {
      runtime.shutdown();
   }

   @Test
   public void testResourceAccess() throws Exception
   {
      assertEquals("Hello from Resource", getHttpResponse("/message.txt"));
   }

   @Test
   public void testServletAccess() throws Exception
   {
      assertEquals("Hello from Servlet", getHttpResponse("/servlet?test=plain"));
   }

   @Test
   public void testServletInitProps() throws Exception
   {
      assertEquals("initProp=SomeValue", getHttpResponse("/servlet?test=initProp"));
   }

   private String getHttpResponse(String reqPath) throws Exception
   {
      URL url = new URL("http://" + runtime.getServerHost() + ":8090/example-webapp" + reqPath);

      int timeout = 50;
      String line = null;
      IOException lastException = null;
      while (line == null && 0 < timeout--)
      {
         try
         {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            line = br.readLine();
         }
         catch (IOException ex)
         {
            lastException = ex;
            Thread.sleep(200);
         }
      }

      if (line == null && lastException != null)
         throw lastException;

      return line;
   }
}