/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.jbosgi99;

//$Id: OSGI39TestCase.java 87103 2009-04-09 22:18:31Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;

import org.jboss.osgi.spi.capability.LogServiceCapability;
import org.jboss.osgi.spi.testing.OSGiBundle;
import org.jboss.osgi.spi.testing.OSGiRuntime;
import org.jboss.osgi.spi.testing.OSGiTestHelper;
import org.junit.Test;
import org.osgi.framework.Bundle;

/**
 * [JBOSGI-99] No explicit control over bundle.start()
 * 
 * https://jira.jboss.org/jira/browse/JBOSGI-99
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2009
 */
public class OSGI99TestCase
{
   @Test
   public void testInstallOnly() throws Exception
   {
      OSGiRuntime runtime = new OSGiTestHelper().getDefaultRuntime();
      try
      {
         runtime.addCapability(new LogServiceCapability());

         OSGiBundle bundleA = runtime.installBundle("jbosgi99-bundleA.jar");
         assertEquals("Bundle installed", Bundle.INSTALLED, bundleA.getState());

         bundleA.start();
         assertEquals("Bundle active", Bundle.ACTIVE, bundleA.getState());

         bundleA.uninstall();
      }
      finally
      {
         runtime.shutdown();
      }
   }
}