/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.service.microcontainer.bundleA;

//$Id: SomeService.java 93025 2009-08-31 13:10:16Z thomas.diesler@jboss.com $

import org.jboss.osgi.spi.service.MicrocontainerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/**
 * A service that accesses the {@link MicrocontainerService}
 * 
 * @author thomas.diesler@jboss.com
 * @since 24-Apr-2009
 */
public class SomeService
{
   private BundleContext context;
   
   public SomeService(BundleContext context)
   {
      this.context = context;
      
      MicrocontainerService mcService = getMicrocontainerService();
      BundleContext bundleContext = (BundleContext)mcService.getRegisteredBean(MicrocontainerService.BEAN_SYSTEM_BUNDLE_CONTEXT);
      if (bundleContext == null)
         throw new IllegalStateException("No BundleContext as MC Bean");
   }

   public String echo(String msg)
   {
      return msg;
   }

   private MicrocontainerService getMicrocontainerService()
   {
      ServiceReference sref = context.getServiceReference(MicrocontainerService.class.getName());
      MicrocontainerService service = (MicrocontainerService)context.getService(sref);
      if (service == null)
         throw new IllegalStateException("No MicrocontainerService");
      
      return service;
   }
}
