package org.jboss.test.osgi.trailblazer;

// $Id: ShoppingMall.java 89657 2009-06-02 10:03:01Z thomas.diesler@jboss.com $

import java.util.Collection;

/**
 * the trailblazer shopping mall.
 * 
 * @author thomas.diesler@jboss.com
 * @since 10-May-2009
 */
public interface ShoppingMall
{
   /**
    * Get the collection of currently registered shops. 
    */
   Collection<Shop> getShops();

   /**
    * Get a shop by name. 
    */
   Shop getShopByName(String shopName);
   
   /**
    * Purchase a product
    */
   void purchaseProduct(Product product);
}