/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.container;

//$Id: AbstractManager.java 90472 2009-06-19 15:11:39Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;

/**
 * Construct a component manager from the given component metadata. 
 *   
 * @author thomas.diesler@jboss.com
 * @since 17-Jun-2009
 */
public class ManagerFactory
{
   protected BlueprintContext context;
   protected BlueprintContainer container;
   
   public ManagerFactory(BlueprintContext context, BlueprintContainer container)
   {
      this.context = context;
      this.container = container;
   }
   
   public AbstractManager createManager(ComponentMetadata comp)
   {
      AbstractManager manager = null;

      if (comp instanceof BeanMetadata)
         manager = new BeanManager(context, container, (BeanMetadata)comp);
      
      else if (comp instanceof ServiceMetadata)
         manager = new ServiceManager(context, container, (ServiceMetadata)comp);
      
      else if (comp instanceof ReferenceMetadata)
         manager = new ReferenceManager(context, container, (ReferenceMetadata)comp);
      
      if (manager == null)
         throw new IllegalArgumentException("Unsupported component type: " + comp);
      
      return manager;
   }
}