/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.extender;

//$Id: BlueprintExtender.java 95177 2009-10-20 15:14:31Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

/**
 * The Blueprint extender
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class BlueprintExtender implements SynchronousBundleListener
{
   private BlueprintProcessor processor;
   
   public BlueprintExtender(BlueprintProcessor processor)
   {
      this.processor = processor;
   }

   /**
    * Start the BlueprintExtender
    */
   public void start()
   {
      BlueprintContext bpContext = processor.getBlueprintContext();
      bpContext.getBundleContext().addBundleListener(this);
   }
   
   /**
    * Stop the BlueprintExtender
    */
   public void stop()
   {
      BlueprintContext bpContext = processor.getBlueprintContext();
      bpContext.getBundleContext().removeBundleListener(this);
      processor.stopAllContainers();
   }

   /**
    * Handle the bundle event
    */
   public void bundleChanged(BundleEvent event)
   {
      Bundle bundle = event.getBundle();
      
      int eventType = event.getType();
      if (eventType == BundleEvent.STARTING)
      {
         if (processor.hasContainer(bundle) == false)
            processor.createContainer(bundle);
      }
      else if (eventType == BundleEvent.STOPPED)
      {
         if (processor.hasContainer(bundle))
            processor.stopContainer(bundle);
      }
   }
}