/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser;

//$Id: SchemaResolverParser.java 97025 2009-11-26 14:35:19Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.net.URL;

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.BlueprintException;
import org.jboss.osgi.blueprint.parser.xb.TBlueprint;
import org.jboss.osgi.jbossxb.UnmarshallerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/**
 * The Blueprint descriptor parser.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class SchemaResolverParser implements JBossXBParser
{
   private BlueprintContext bpContext;

   public SchemaResolverParser(BlueprintContext bpContext)
   {
      this.bpContext = bpContext;
   }

   /*
    * Parse a blueprint descriptor
    */
   public TBlueprint parse(URL xmlURL)
   {
      if (xmlURL == null)
         throw new IllegalArgumentException("Cannot parse null descriptor URL");

      BundleContext context = bpContext.getBundleContext();
      ServiceReference sref = context.getServiceReference(UnmarshallerService.class.getName());
      if (sref == null)
         throw new IllegalStateException("Cannot obtain: " + UnmarshallerService.class.getName());

      UnmarshallerService unmarshaller = (UnmarshallerService)context.getService(sref);
      try
      {
         unmarshaller.setSchemaValidation(true);
         unmarshaller.setNamespaceAware(true);
         unmarshaller.setValidation(true);

         unmarshaller.registerSchemaLocation("http://www.osgi.org/xmlns/blueprint/v1.0.0/blueprint.xsd", "schema/blueprint.xsd");

         unmarshaller.addClassBinding(BlueprintContext.XMLNS_BLUEPRINT, TBlueprint.class);

         TBlueprint tBlueprint = (TBlueprint)unmarshaller.unmarshal(xmlURL.toExternalForm());

         return tBlueprint;
      }
      catch (IOException ex)
      {
         throw new BlueprintException("Cannot parse blueprint descriptor: " + xmlURL, ex);
      }
   }
}