/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: GValue.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * The set of "value" types that can be used in any place a value
 * can be specified.  This set includes the <ref> and <idref> elements, any of the
 * component types (<bean>, <service>, etc.) as inline components, the
 * generic <value> element for types sourced from string values, any of the
 * collection types (<set>, <list>, <array>, <map>, <props>), and the
 * <null> type to inject a null value.
 *  
 * <xsd:group name="Gvalue">
 *  <xsd:choice>
 *    <xsd:group ref="GnonNullValue" />
 *    <xsd:element name="null" type="Tnull" />
 *  </xsd:choice>
 * </xsd:group>
 * 
 * <xsd:group name="GnonNullValue">
 *  <xsd:choice>
 *    <xsd:group ref="GallComponents" />
 *    <xsd:element name="idref" type="Tref" />
 *    <xsd:element name="value" type="Tvalue" />
 *    <xsd:element name="list" type="Tcollection" />
 *    <xsd:element name="set" type="Tcollection" />
 *    <xsd:element name="map" type="Tmap" />
 *    <xsd:element name="array" type="Tcollection" />
 *    <xsd:element name="props" type="Tprops" />
 *  </xsd:choice>
 * </xsd:group>
 *
 * <xsd:group name="GallComponents">
 *  <xsd:choice>
 *    <xsd:element name="service" type="Tinlined-service" />
 *    <xsd:element name="reference-list" type="Tinlined-reference-list" />
 *    <xsd:group ref="GtargetComponent" />
 *  </xsd:choice>
 * </xsd:group>
 *
 * <xsd:group name="GtargetComponent">
 *  <xsd:choice>
 *    <xsd:element name="bean" type="Tinlined-bean" />
 *    <xsd:element name="reference" type="Tinlined-reference" />
 *    <xsd:element name="ref" type="Tref" />
 *    <xsd:any namespace="##other" processContents="strict" />
 *  </xsd:choice>
 * </xsd:group>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Gvalue", namespace = BlueprintContext.XMLNS_BLUEPRINT)
public class GValue
{
   protected Object valueElement;

   @XmlElements( { 
      @XmlElement(name = "service", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TService.class),
      @XmlElement(name = "reference-list", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TReferenceList.class), 
      @XmlElement(name = "bean", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TBean.class), 
      @XmlElement(name = "reference", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TReference.class), 
      @XmlElement(name = "ref", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TRef.class), 
      @XmlElement(name = "idref", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = String.class), 
      @XmlElement(name = "value", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TValue.class), 
      @XmlElement(name = "list", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = List.class), 
      @XmlElement(name = "set", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = Set.class), 
      @XmlElement(name = "map", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = Map.class), 
      @XmlElement(name = "array", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = List.class), 
      @XmlElement(name = "props", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TProps.class), 
      @XmlElement(name = "null", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = List.class) 
      })
   public Object getValueElement()
   {
      return valueElement;
   }

   public void setValueElement(Object valueElement)
   {
      this.valueElement = valueElement;
   }
}
