/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TAutoExportModes.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

/**
 * TautoExportModes is a base type that should be used for export-mode attributes.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public enum TAutoExportModes
{
   // [JBXB-209] Enum parsing requires value equal to type name
   // https://jira.jboss.org/jira/browse/JBXB-209
   disabled("disabled"), 
   interfaces("interfaces"), 
   class_hierarchy("class-hierarchy"), 
   all_classes("all-classes");

   private final String value;

   TAutoExportModes(String v)
   {
      value = v;
   }

   public String value()
   {
      return value;
   }

   public static TAutoExportModes fromValue(String v)
   {
      for (TAutoExportModes c : TAutoExportModes.values())
      {
         if (c.value.equals(v))
         {
            return c;
         }
      }
      throw new IllegalArgumentException(v);
   }

}
