/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

/**
 * Tavailability defines an availability attribute type.  This is used in this
 * schema by the <blueprint> default-availability attribute and the
 * <reference> and <reference-list> availability attribute.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public enum TAvailability
{
   // [JBXB-209] Enum parsing requires value equal to type name
   // https://jira.jboss.org/jira/browse/JBXB-209
   mandatory("mandatory"), 
   optional("optional");

   private final String value;

   TAvailability(String v)
   {
      value = v;
   }

   public String value()
   {
      return value;
   }

   public static TAvailability fromValue(String v)
   {
      for (TAvailability c : TAvailability.values())
      {
         if (c.value.equals(v))
         {
            return c;
         }
      }
      throw new IllegalArgumentException(v);
   }
}