/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TProperty.java 91348 2009-07-16 15:54:22Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * A property that will be injected into a created <bean> component. The <property> elements correspond to named JavaBean setting methods for a created bean object.
 * 
 * The value and ref attributes are convenience shortcuts to make the <argument> tag easier to code. A fuller set of injected values and types can be specified using
 * one of the "value" type elements.
 * 
 * <xsd:complexType name="Tproperty"> <xsd:sequence> <xsd:element name="description" type="Tdescription" minOccurs="0" /> <xsd:group ref="Gvalue" minOccurs="0" />
 * </xsd:sequence> <xsd:attribute name="name" type="Tmethod" use="required" /> <xsd:attribute name="ref" type="Tidref" /> <xsd:attribute name="value"
 * type="TstringValue" /> </xsd:complexType>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Tproperty", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "description" })
public class TProperty extends GValue
{
   protected String description;
   protected String name;
   protected String ref;
   protected String value;

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String value)
   {
      this.description = value;
   }

   @XmlAttribute(required = true)
   public String getName()
   {
      return name;
   }

   public void setName(String value)
   {
      this.name = value;
   }

   @XmlAttribute
   public String getRef()
   {
      return ref;
   }

   public void setRef(String value)
   {
      this.ref = value;
   }

   @XmlAttribute
   public String getValue()
   {
      return value;
   }

   public void setValue(String value)
   {
      this.value = value;
   }
}
