/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

//$Id: TReferenceListener.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * TReferenceListener defines a reference listener that is attached
 * to a <reference> or <reference-list> element.  The listener
 * object can be specified as a <ref> or as an inline <bean> or
 * <reference> component.  Listener events are mapped to the indicated
 * bind or unbind methods.
 * 
 * <xsd:complexType name="TreferenceListener">
 *   <xsd:sequence>
 *     <xsd:group ref="GtargetComponent" minOccurs="0" />
 *   </xsd:sequence>
 *   <xsd:attribute name="ref" type="Tidref" />
 *   <xsd:attribute name="bind-method" type="Tmethod" />
 *   <xsd:attribute name="unbind-method" type="Tmethod" />
 * </xsd:complexType>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */

//[JBXB-210] Property order cannot be defined on super type
//https://jira.jboss.org/jira/browse/JBXB-210
//@XmlType(name = "TreferenceListener", namespace = BlueprintContext.XMLNS_BLUEPRINT)

@XmlType(name = "TreferenceListener", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "bean", "reference", "refElement" })
public class TReferenceListener extends GTargetComponent
{
   protected String ref;
   protected String bindMethod;
   protected String unbindMethod;

   @XmlAttribute
   public String getRef()
   {
      return ref;
   }

   public void setRef(String ref)
   {
      this.ref = ref;
   }

   @XmlAttribute
   public String getBindMethod()
   {
      return bindMethod;
   }

   public void setBindMethod(String value)
   {
      this.bindMethod = value;
   }

   @XmlAttribute
   public String getUnbindMethod()
   {
      return unbindMethod;
   }

   public void setUnbindMethod(String value)
   {
      this.unbindMethod = value;
   }

}
