/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TTypeConverters.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;


/**
 * The type used for the <type-converters> element.
 *   
 * The <type-converters> section is a set of <bean>, <ref>, or
 * <reference> elements that identify the type converter components.
 *
 * <xsd:complexType name="Ttype-converters">
 *  <xsd:choice minOccurs="0" maxOccurs="unbounded">
 *    <xsd:element name="bean" type="Tbean" />
 *    <xsd:element name="reference" type="Treference" />
 *    <xsd:element name="ref" type="Tref" />
 *    <xsd:any namespace="##other" processContents="strict" />
 *  </xsd:choice>
 * </xsd:complexType>
 *
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Ttype-converters", namespace = BlueprintContext.XMLNS_BLUEPRINT)
public class TTypeConverters
{
   protected List<Object> components;

   @XmlElements( { 
      @XmlElement(name = "bean", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TBean.class),
      @XmlElement(name = "reference", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TReference.class),
      @XmlElement(name = "ref", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TRef.class)})
   public List<Object> getComponents()
   {
      if (components == null)
         components = new ArrayList<Object>();
      
      return components;
   }

   public void setComponents(List<Object> converters)
   {
      this.components = converters;
   }
   
   public void resolveRefs(TBlueprint tBlueprint)
   {
      for (int i = 0; i < getComponents().size(); i++)
      {
         Object comp = components.get(i);
         if (comp instanceof TRef)
         {
            TRef ref = (TRef)comp;
            String compName = ref.getComponentId();
            comp = tBlueprint.getComponentMetadata(compName);
            components.set(i, comp);
         }
      }
   }
}
