/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.reflect;

// $Id: BeanMetadataImpl.java 90477 2009-06-19 19:29:55Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TBean;
import org.jboss.osgi.blueprint.parser.xb.TProperty;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Target;

/**
 * Metadata for a Bean Component.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class BeanMetadataImpl extends ComponentMetadataImpl implements BeanMetadata
{
   private ComponentMetadata parent;
   private TBean tBean;
   private List<BeanProperty> properties;

   public BeanMetadataImpl(BlueprintContext context, BlueprintMetadata blueprint, TBean tBean)
   {
      this(context, blueprint, null, tBean);
   }

   public BeanMetadataImpl(BlueprintContext context, BlueprintMetadata blueprint, ComponentMetadata parent, TBean tBean)
   {
      super(context, blueprint, tBean);
      this.parent = parent;
      this.tBean = tBean;
   }

   public String getKey()
   {
      String key = super.getId();
      if (key == null && parent != null)
         key = parent.getId() + "#anonymousBean";

      return key;
   }

   public List<BeanArgument> getArguments()
   {
      throw new NotImplementedException();
   }

   public String getClassName()
   {
      return tBean.getClassName();
   }

   public String getDestroyMethod()
   {
      return tBean.getDestroyMethod();
   }

   public Target getFactoryComponent()
   {
      throw new NotImplementedException();
   }

   public String getFactoryMethod()
   {
      return tBean.getFactoryMethod();
   }

   public String getInitMethod()
   {
      return tBean.getInitMethod();
   }

   public List<BeanProperty> getProperties()
   {
      if (properties == null)
      {
         properties = new ArrayList<BeanProperty>();
         for (TProperty prop : tBean.getProperties())
         {
            properties.add(new BeanPropertyImpl(context, blueprint, prop));
         }
      }
      return Collections.unmodifiableList(properties);
   }

   public Class<?> getRuntimeClass()
   {
      throw new NotImplementedException();
   }

   public String getScope()
   {
      return tBean.getScope();
   }

   public String toString()
   {
      return "Bean[key=" + getKey() + "]";
   }
}
