/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.blueprint.parser;

//$Id: AbstractParserTestCase.java 97026 2009-11-26 14:36:24Z thomas.diesler@jboss.com $

import java.net.URL;

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TBlueprint;
import org.jboss.osgi.testing.OSGiTest;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;

/**
 * An abstract Blueprint parser
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public abstract class AbstractParserTestCase extends OSGiTest
{
   protected TBlueprint parse(URL xmlURL) throws JBossXBException
   {
      if (xmlURL == null)
         throw new IllegalArgumentException("Cannot parse null descriptor URL");

      Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
      unmarshaller.setSchemaValidation(true);
      unmarshaller.setNamespaceAware(true);
      unmarshaller.setValidation(true);

      JBossEntityResolver entityResolver = new JBossEntityResolver();
      entityResolver.registerLocalEntity("http://www.osgi.org/xmlns/blueprint/v1.0.0/blueprint.xsd", "schema/blueprint.xsd");
      unmarshaller.setEntityResolver(entityResolver);

      DefaultSchemaResolver schemaBindingResolver = new DefaultSchemaResolver();
      schemaBindingResolver.addClassBinding(BlueprintContext.XMLNS_BLUEPRINT, TBlueprint.class);

      TBlueprint tBlueprint = (TBlueprint)unmarshaller.unmarshal(xmlURL.toExternalForm(), schemaBindingResolver);
      return tBlueprint;
   }
}