/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.blueprint.parser;

//$Id: AllElementsParserTestCase.java 97033 2009-11-26 15:53:09Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URL;
import java.util.Collection;
import java.util.List;

import org.jboss.osgi.blueprint.parser.xb.TActivation;
import org.jboss.osgi.blueprint.parser.xb.TAvailability;
import org.jboss.osgi.blueprint.parser.xb.TBean;
import org.jboss.osgi.blueprint.parser.xb.TBlueprint;
import org.jboss.osgi.blueprint.parser.xb.TRef;
import org.jboss.osgi.blueprint.parser.xb.TReference;
import org.jboss.osgi.blueprint.parser.xb.TService;
import org.jboss.osgi.blueprint.parser.xb.TServiceReference;
import org.jboss.osgi.blueprint.parser.xb.TTypeConverters;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Blueprint parser tests
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class AllElementsParserTestCase extends AbstractParserTestCase
{
   private static TBlueprint blueprint;

   @BeforeClass
   public static void beforeClass() throws Exception
   {
      URL xmlURL = new OSGiTestHelper().getResourceURL("parser/blueprint-all-elements.xml");
      blueprint = new AllElementsParserTestCase().parse(xmlURL);
   }

   @Test
   public void testRootAttributes() throws Exception
   {
      TAvailability defaultAvailability = blueprint.getDefaultAvailability();
      assertEquals(TAvailability.mandatory, defaultAvailability);
      
      TActivation defaultActivation = blueprint.getDefaultActivation();
      assertEquals(TActivation.eager, defaultActivation);
      
      long defaultTimeout = blueprint.getDefaultTimeout().longValue();
      assertEquals(300000, defaultTimeout);
   }

   @Test
   public void getDescription() throws Exception
   {
      String description = blueprint.getDescription();
      assertEquals("blueprint description", description);
   }

   @Test
   public void getTypeConverters() throws Exception
   {
      TTypeConverters typeConverters = blueprint.getTypeConverters();
      assertNotNull("TypeConverters not null", typeConverters);
      
      List<Object> converters = typeConverters.getComponents();
      assertEquals("TypeConverters size", 5, converters.size());
      
      TBean conv1 = (TBean)converters.get(0);
      assertNotNull("Converter not null", conv1);
      
      TReference conv2 = (TReference)converters.get(1);
      assertNotNull("Converter not null", conv2);
      
      TReference conv3 = (TReference)converters.get(2);
      assertNotNull("Converter not null", conv3);
      
      TRef conv4 = (TRef)converters.get(3);
      assertNotNull("Converter not null", conv4);
      
      TRef conv5 = (TRef)converters.get(4);
      assertNotNull("Converter not null", conv5);
   }

   @Test
   public void getExportedServicesMetadata() throws Exception
   {
      Collection<TService> services = blueprint.getMetadata(TService.class);
      assertNotNull("ServiceMetadata not null", services);
      assertEquals("ServiceMetadata size", 2, services.size());
   }

   @Test
   public void getReferencedServicesMetadata() throws Exception
   {
      Collection<TServiceReference> serviceRefs = blueprint.getMetadata(TServiceReference.class);
      assertNotNull("ServiceReferenceMetadata not null", serviceRefs);
      assertEquals("ServiceReferenceMetadata size", 2, serviceRefs.size());
   }

   @Test
   public void getBeanComponentsMetadata() throws Exception
   {
      Collection<TBean> beans = blueprint.getMetadata(TBean.class);
      assertNotNull("BeanMetadata not null", beans);
      assertEquals("BeanMetadata size", 3, beans.size());
   }
}