/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.blueprint.parser;

//$Id: BasicServiceParserTestCase.java 97025 2009-11-26 14:35:19Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.jboss.osgi.blueprint.parser.xb.TBean;
import org.jboss.osgi.blueprint.parser.xb.TBlueprint;
import org.jboss.osgi.blueprint.parser.xb.TComponent;
import org.jboss.osgi.blueprint.parser.xb.TService;
import org.jboss.test.osgi.blueprint.parser.common.BeanA;
import org.jboss.test.osgi.blueprint.parser.common.ServiceA;
import org.jboss.test.osgi.blueprint.parser.common.ServiceB;
import org.junit.Test;

/**
 * Blueprint parser tests
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class BasicServiceParserTestCase extends AbstractParserTestCase
{
   @Test
   public void testBasicService() throws Exception
   {
      TBlueprint blueprint = parse(getResourceURL("parser/blueprint-basic-service.xml"));

      List<TComponent> compList = blueprint.getComponents();
      assertTrue(compList.size() > 0);

      TBean beanA = (TBean)compList.get(0);
      assertEquals(BeanA.class.getName(), beanA.getClassName());
      assertEquals("beanA", beanA.getId());

      TService serviceA = (TService)compList.get(1);
      assertEquals("serviceA", serviceA.getId());

      List<String> intfsA = serviceA.getInterfaces().getValues();
      assertTrue(intfsA.size() > 0);
      assertEquals(ServiceA.class.getName(), intfsA.get(0));

      TService serviceB = (TService)compList.get(2);
      assertEquals("serviceB", serviceB.getId());

      List<String> intfsB = serviceB.getInterfaces().getValues();
      assertTrue(intfsB.size() > 0);
      assertEquals(ServiceB.class.getName(), intfsB.get(0));
   }
}