/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.blueprint.parser;

//$Id: BlueprintContainerParserTestCase.java 97025 2009-11-26 14:35:19Z thomas.diesler@jboss.com $

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URL;
import java.util.List;

import javax.management.MBeanServer;

import org.jboss.osgi.blueprint.parser.xb.TBean;
import org.jboss.osgi.blueprint.parser.xb.TBlueprint;
import org.jboss.osgi.blueprint.parser.xb.TProperty;
import org.jboss.osgi.blueprint.parser.xb.TReference;
import org.jboss.osgi.blueprint.parser.xb.TService;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.test.osgi.blueprint.container.bundle.BeanA;
import org.jboss.test.osgi.blueprint.container.bundle.BeanB;
import org.jboss.test.osgi.blueprint.container.bundle.ServiceA;
import org.jboss.test.osgi.blueprint.container.bundle.ServiceB;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Blueprint parser tests
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class BlueprintContainerParserTestCase extends AbstractParserTestCase
{
   private static TBlueprint blueprint;

   @BeforeClass
   public static void beforeClass() throws Exception
   {
      URL xmlURL = new OSGiTestHelper().getResourceURL("container/OSGI-INF/blueprint/basic-service.xml");
      blueprint = new BlueprintContainerParserTestCase().parse(xmlURL);
   }

   @Test
   public void getBeanMetadata() throws Exception
   {
      List<TBean> beans = blueprint.getMetadata(TBean.class);
      assertNotNull("TBeans not null", beans);
      assertEquals("TBeans size", 1, beans.size());
      
      TBean bean = beans.get(0);
      assertNotNull("TBean not null", bean);
      assertEquals(BeanA.class.getName(), bean.getClassName());
      
      List<TProperty> props = bean.getProperties();
      assertNotNull("TProperties not null", props);
      assertEquals("TProperties size", 1, props.size());
      
      TProperty prop = props.get(0);
      assertNotNull("TProperty not null", prop);
      assertEquals("mbeanServer", prop.getName());
      assertEquals("mbeanService", prop.getRef());
   }

   @Test
   public void getServiceMetadata() throws Exception
   {
      List<TService> services = blueprint.getMetadata(TService.class);
      assertNotNull("TServices not null", services);
      assertEquals("TServices size", 2, services.size());
      
      TService serviceA = services.get(0);
      assertEquals("serviceA", serviceA.getId());
      assertEquals("beanA", serviceA.getRef());
      assertEquals(ServiceA.class.getName(), serviceA.getInterface());
      
      TService serviceB = services.get(1);
      assertEquals("serviceB", serviceB.getId());
      assertEquals(ServiceB.class.getName(), serviceB.getInterface());
      
      TBean bean = serviceB.getBean();
      assertNotNull("TBean not null", bean);
      assertEquals(BeanB.class.getName(), bean.getClassName());
      
      List<TProperty> props = bean.getProperties();
      assertNotNull("TProperties not null", props);
      assertEquals("TProperties size", 1, props.size());
      
      TProperty prop = props.get(0);
      assertNotNull("TProperty not null", prop);
      assertEquals("beanA", prop.getName());
      assertEquals("beanA", prop.getRef());
   }

   @Test
   public void getReferenceMetadata() throws Exception
   {
      List<TReference> references = blueprint.getMetadata(TReference.class);
      assertNotNull("TReferences not null", references);
      assertEquals("TReferences size", 1, references.size());
      
      TReference ref = references.get(0);
      assertEquals("mbeanService", ref.getId());
      assertEquals(MBeanServer.class.getName(), ref.getInterface());
   }
}