/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.osgi.jbosgi212;

//$Id:$

import static org.junit.Assert.assertNotNull;

import org.jboss.osgi.microcontainer.MicrocontainerCapability;
import org.jboss.osgi.spi.service.MicrocontainerService;
import org.jboss.osgi.testing.OSGiBundle;
import org.jboss.osgi.testing.OSGiRuntime;
import org.jboss.osgi.testing.OSGiServiceReference;
import org.jboss.osgi.testing.OSGiTest;
import org.junit.Test;
import org.osgi.framework.Bundle;

/**
 * [JBOSGI-212] Cannot refresh Microcontainer service
 * 
 * https://jira.jboss.org/jira/browse/JBOSGI-212
 * 
 * @author thomas.diesler@jboss.com
 * @since 25-Nov-2009
 */
public class OSGI212TestCase extends OSGiTest
{
   @Test
   public void testServiceRestart() throws Exception
   {
      OSGiRuntime runtime = getDefaultRuntime();
      try
      {
         runtime.addCapability(new MicrocontainerCapability());

         // On the MC Framework there is no such bundle. The service should still be available.
         OSGiBundle bundle = runtime.getBundle("jboss-osgi-microcontainer", null);
         if (bundle != null)
         {
            assertNotNull("MicrocontainerService available", bundle);
            assertBundleState(Bundle.ACTIVE, bundle.getState());
            
            // Update the MC bundle
            bundle.stop();
            bundle.start();
         }
         
         OSGiServiceReference sref = runtime.getServiceReference(MicrocontainerService.class.getName());
         assertNotNull("MicrocontainerService still available", sref);
      }
      finally
      {
         runtime.shutdown();
      }
   }
}