/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ExtendedUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntActionInstallerListener
extends SimpleInstallerListener {
    public static final String SPEC_FILE_NAME = "AntActionsSpec.xml";
    private HashMap<String, HashMap<Object, ArrayList<AntAction>>> actions = new HashMap();
    private ArrayList<AntAction> uninstActions = new ArrayList();

    public AntActionInstallerListener() {
        super(true);
    }

    public HashMap<String, HashMap<Object, ArrayList<AntAction>>> getActions() {
        return this.actions;
    }

    @Override
    public void beforePacks(AutomatedInstallData automatedInstallData, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        Object object;
        super.beforePacks(automatedInstallData, n, abstractUIProgressHandler);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME, new VariableSubstitutor(automatedInstallData.getVariables()));
        if (this.getSpecHelper().getSpec() == null) {
            return;
        }
        Iterator<Pack> iterator = automatedInstallData.selectedPacks.iterator();
        Pack pack = null;
        while (iterator != null && iterator.hasNext()) {
            pack = iterator.next();
            object = this.getSpecHelper().getPackForName(pack.name);
            if (object == null) continue;
            HashMap hashMap = new HashMap();
            hashMap.put("beforepack", new ArrayList());
            hashMap.put("afterpack", new ArrayList());
            hashMap.put("beforepacks", new ArrayList());
            hashMap.put("afterpacks", new ArrayList());
            Vector<IXMLElement> vector = object.getChildrenNamed("antcall");
            if (vector != null && vector.size() >= 1) {
                Iterator<IXMLElement> iterator2 = vector.iterator();
                while (iterator2 != null && iterator2.hasNext()) {
                    AntAction antAction = this.readAntCall(iterator2.next(), automatedInstallData);
                    if (antAction == null) continue;
                    ((ArrayList)hashMap.get(antAction.getOrder())).add(antAction);
                }
                if (((ArrayList)hashMap.get("afterpacks")).size() > 0) {
                    this.setProgressBarCaller();
                }
            }
            this.actions.put(pack.name, hashMap);
        }
        iterator = automatedInstallData.availablePacks.iterator();
        while (iterator.hasNext()) {
            object = iterator.next().name;
            this.performAllActions((String)object, "beforepacks", null);
        }
    }

    @Override
    public void beforePack(Pack pack, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        this.performAllActions(pack.name, "beforepack", abstractUIProgressHandler);
    }

    @Override
    public void afterPack(Pack pack, Integer n, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        this.performAllActions(pack.name, "afterpack", abstractUIProgressHandler);
    }

    @Override
    public void afterPacks(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        if (this.informProgressBar()) {
            abstractUIProgressHandler.nextStep(this.getMsg("AntAction.pack"), this.getProgressBarCallerId(), this.getActionCount(automatedInstallData, "afterpacks"));
        }
        Iterator<Pack> iterator = automatedInstallData.selectedPacks.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().name;
            this.performAllActions(string, "afterpacks", abstractUIProgressHandler);
        }
        if (this.uninstActions.size() > 0) {
            UninstallData.getInstance().addAdditionalData("antActions", this.uninstActions);
        }
    }

    private int getActionCount(AutomatedInstallData automatedInstallData, String string) {
        int n = 0;
        Iterator<Pack> iterator = automatedInstallData.selectedPacks.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().name;
            ArrayList<AntAction> arrayList = this.getActions(string2, string);
            if (arrayList == null) continue;
            n += arrayList.size();
        }
        return n;
    }

    protected ArrayList<AntAction> getActions(String string, String string2) {
        if (this.actions == null) {
            return null;
        }
        HashMap<Object, ArrayList<AntAction>> hashMap = this.actions.get(string);
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        return hashMap.get(string2);
    }

    private void performAllActions(String string, String string2, AbstractUIProgressHandler abstractUIProgressHandler) throws InstallerException {
        ArrayList<AntAction> arrayList = this.getActions(string, string2);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        Debug.trace("******* Executing all " + string2 + " actions of " + string + " ...");
        for (AntAction antAction : arrayList) {
            if (this.informProgressBar() && abstractUIProgressHandler != null && abstractUIProgressHandler instanceof ExtendedUIProgressHandler && string2.equals("afterpacks")) {
                ((ExtendedUIProgressHandler)((Object)abstractUIProgressHandler)).progress(antAction.getMessageID() != null ? this.getMsg(antAction.getMessageID()) : "");
            }
            try {
                antAction.performInstallAction();
            }
            catch (Exception exception) {
                throw new InstallerException(exception);
            }
            if (antAction.getUninstallTargets().size() <= 0) continue;
            this.uninstActions.add(antAction);
        }
    }

    private AntAction readAntCall(IXMLElement iXMLElement, AutomatedInstallData automatedInstallData) throws InstallerException {
        String string;
        String string2 = null;
        String string3 = null;
        if (iXMLElement == null) {
            return null;
        }
        SpecHelper specHelper = this.getSpecHelper();
        AntAction antAction = new AntAction();
        try {
            antAction.setOrder(specHelper.getRequiredAttribute(iXMLElement, "order"));
            antAction.setUninstallOrder(iXMLElement.getAttribute("uninstall_order", "beforedeletion"));
        }
        catch (Exception exception) {
            throw new InstallerException(exception);
        }
        antAction.setQuiet(specHelper.isAttributeYes(iXMLElement, "quiet", false));
        antAction.setVerbose(specHelper.isAttributeYes(iXMLElement, "verbose", false));
        string2 = iXMLElement.getAttribute("buildfile");
        string3 = this.processBuildfileResource(specHelper, automatedInstallData, iXMLElement);
        if (null == string2 && null == string3) {
            throw new InstallerException("Invalid AntActionsSpec.xml: either buildfile or buildresource must be specified");
        }
        if (null != string2 && null != string3) {
            throw new InstallerException("Invalid AntActionsSpec.xml: cannot specify both buildfile and buildresource");
        }
        if (null != string2) {
            antAction.setBuildFile(string2);
        } else {
            antAction.setBuildFile(string3);
        }
        String string4 = iXMLElement.getAttribute("logfile");
        if (string4 != null) {
            antAction.setLogFile(string4);
        }
        if ((string = iXMLElement.getAttribute("messageid")) != null && string.length() > 0) {
            antAction.setMessageID(string);
        }
        for (IXMLElement iXMLElement2 : iXMLElement.getChildrenNamed("propertyfile")) {
            antAction.addPropertyFile(specHelper.getRequiredAttribute(iXMLElement2, "path"));
        }
        for (IXMLElement iXMLElement2 : iXMLElement.getChildrenNamed("property")) {
            antAction.setProperty(specHelper.getRequiredAttribute(iXMLElement2, "name"), specHelper.getRequiredAttribute(iXMLElement2, "value"));
        }
        for (IXMLElement iXMLElement2 : iXMLElement.getChildrenNamed("target")) {
            antAction.addTarget(specHelper.getRequiredAttribute(iXMLElement2, "name"));
        }
        for (IXMLElement iXMLElement2 : iXMLElement.getChildrenNamed("uninstall_target")) {
            antAction.addUninstallTarget(specHelper.getRequiredAttribute(iXMLElement2, "name"));
        }
        if (null != string3 && antAction.getUninstallTargets().size() > 0) {
            this.addBuildResourceToUninstallerData(string3);
        }
        return antAction;
    }

    private String processBuildfileResource(SpecHelper specHelper, AutomatedInstallData automatedInstallData, IXMLElement iXMLElement) throws InstallerException {
        String string = null;
        String string2 = iXMLElement.getAttribute("buildresource");
        if (null != string2) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(specHelper.getResource(string2));
            if (null == bufferedInputStream) {
                throw new InstallerException("Failed to find buildfile_resource: " + string2);
            }
            FilterOutputStream filterOutputStream = null;
            try {
                int n;
                File file = File.createTempFile("buildfile_resource", "xml");
                file.deleteOnExit();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                while (-1 != (n = bufferedInputStream.read())) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
                bufferedInputStream.close();
                filterOutputStream.close();
                string = file.getAbsolutePath();
            }
            catch (Exception exception) {
                throw new InstallerException("Failed to write buildfile_resource", exception);
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return string;
    }

    private void addBuildResourceToUninstallerData(String string) throws InstallerException {
        byte[] byArray = null;
        File file = new File(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            while (-1 != (n = bufferedInputStream.read())) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            UninstallData.getInstance().addAdditionalData("build_resource", byArray);
        }
        catch (Exception exception) {
            throw new InstallerException("Failed to add buildfile_resource to uninstaller", exception);
        }
        finally {
            try {
                bufferedInputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

