/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class PasswordEncryptionValidator
implements Validator {
    private Cipher encryptCipher;

    public boolean validate(ProcessingClient processingClient) {
        boolean bl = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        Map map = this.getParams(processingClient);
        try {
            string2 = (String)map.get("encryptionKey");
            string3 = (String)map.get("algorithm");
            if (string2 != null && string3 != null) {
                this.initialize(string2, string3);
                string = this.encryptString(processingClient.getFieldContents(0));
                if (string != null) {
                    PasswordGroup passwordGroup = (PasswordGroup)processingClient;
                    passwordGroup.setModifiedPassword(string);
                } else {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            Debug.trace("Password Encryption Failed: " + exception);
            bl = false;
        }
        return bl;
    }

    private Map getParams(ProcessingClient processingClient) {
        PasswordGroup passwordGroup = null;
        Map<String, String> map = null;
        try {
            passwordGroup = (PasswordGroup)processingClient;
            if (passwordGroup.hasParams()) {
                map = passwordGroup.getValidatorParams();
            }
        }
        catch (Exception exception) {
            Debug.trace("getParams() Failed: " + exception);
        }
        return map;
    }

    private void initialize(String string, String string2) throws Exception {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string2);
            keyGenerator.init(new SecureRandom(string.getBytes()));
            byte[] byArray = keyGenerator.generateKey().getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string2);
            this.encryptCipher = Cipher.getInstance(string2);
            this.encryptCipher.init(1, secretKeySpec);
        }
        catch (Exception exception) {
            Debug.trace("Error initializing password encryption " + exception.getMessage());
            throw exception;
        }
    }

    public String encryptString(String string) throws Exception {
        String string2 = null;
        try {
            byte[] byArray = null;
            byArray = this.encryptCipher.doFinal(string.getBytes("UTF-8"));
            string2 = new BASE64Encoder().encode(byArray);
        }
        catch (Exception exception) {
            Debug.trace("Error encrypting string: " + exception.getMessage());
            throw exception;
        }
        return string2;
    }
}

