/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.provision.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.osgi.provision.AbstractResourceProvisioner;
import org.jboss.osgi.provision.ProvisionException;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.repository.RepositoryContent;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceProvisionerActivator
implements BundleActivator {
    private final AtomicLong installIndex = new AtomicLong();
    private ServiceTracker<XResolver, XResolver> resolverTracker;
    private ServiceTracker<XRepository, XPersistentRepository> repositoryTracker;
    private ServiceRegistration<XResourceProvisioner> registration;

    public void start(BundleContext context) throws Exception {
        this.resolverTracker = new ServiceTracker<XResolver, XResolver>(context, XResolver.class, null){

            public XResolver addingService(ServiceReference<XResolver> reference) {
                XResolver resolver = (XResolver)super.addingService(reference);
                ResourceProvisionerActivator.this.createProvisionService(this.context, resolver, (XPersistentRepository)ResourceProvisionerActivator.this.repositoryTracker.getService());
                return resolver;
            }
        };
        this.repositoryTracker = new ServiceTracker<XRepository, XPersistentRepository>(context, XRepository.class, null){

            public XPersistentRepository addingService(ServiceReference<XRepository> reference) {
                XPersistentRepository repository = (XPersistentRepository)super.addingService(reference);
                ResourceProvisionerActivator.this.createProvisionService(this.context, (XResolver)ResourceProvisionerActivator.this.resolverTracker.getService(), repository);
                return repository;
            }
        };
        this.resolverTracker.open();
        this.repositoryTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.resolverTracker != null) {
            this.resolverTracker.close();
        }
        if (this.repositoryTracker != null) {
            this.repositoryTracker.close();
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private void createProvisionService(final BundleContext context, XResolver resolver, XPersistentRepository repository) {
        if (resolver != null && repository != null) {
            AbstractResourceProvisioner service = new AbstractResourceProvisioner(resolver, repository){

                @Override
                public <T> List<T> installResources(List<XResource> resources) throws ProvisionException {
                    String locationBase = context.getBundle().getLocation();
                    ArrayList<Bundle> result = new ArrayList<Bundle>();
                    for (XResource res : resources) {
                        try {
                            String location = locationBase + "/resource" + ResourceProvisionerActivator.this.installIndex.incrementAndGet();
                            InputStream input = ((RepositoryContent)res).getContent();
                            Bundle bundle2 = context.installBundle(location, input);
                            result.add(bundle2);
                        }
                        catch (BundleException ex) {
                            throw new ProvisionException(ex);
                        }
                    }
                    return Collections.unmodifiableList(result);
                }
            };
            this.registration = context.registerService(XResourceProvisioner.class, (Object)service, null);
        }
    }
}

