/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.provision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.provision.ProvisionLogger;
import org.jboss.osgi.provision.ProvisionMessages;
import org.jboss.osgi.provision.ProvisionResult;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractEnvironment;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public class AbstractResourceProvisioner
implements XResourceProvisioner {
    private final XResolver resolver;
    private final XRepository repository;

    public AbstractResourceProvisioner(XResolver resolver, XRepository repository) {
        this.resolver = resolver;
        this.repository = repository;
    }

    @Override
    public final XResolver getResolver() {
        return this.resolver;
    }

    @Override
    public final XRepository getRepository() {
        return this.repository;
    }

    @Override
    public final ProvisionResult findResources(XEnvironment env, Set<XRequirement> reqs) {
        if (env == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("env");
        }
        if (reqs == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("reqs");
        }
        ProvisionLogger.LOGGER.debugf("START findResources: %s", reqs);
        ArrayList<XResource> unresolved = new ArrayList<XResource>();
        XEnvironment envclone = this.cloneEnvironment(env);
        for (XRequirement req : reqs) {
            XResource res = req.getResource();
            if (res.getState() == XResource.State.INSTALLED) continue;
            envclone.installResources(new XResource[]{res});
            unresolved.add(res);
        }
        ArrayList<XResource> resources = new ArrayList<XResource>();
        HashSet<XRequirement> unstatisfied = new HashSet<XRequirement>(reqs);
        HashMap<XRequirement, XResource> mapping = new HashMap<XRequirement, XResource>();
        this.findResources(envclone, unresolved, mapping, unstatisfied, resources);
        Iterator itres = resources.iterator();
        while (itres.hasNext()) {
            XResource res = (XResource)itres.next();
            if (!res.isAbstract()) continue;
            itres.remove();
        }
        AbstractProvisionResult result = new AbstractProvisionResult(mapping, unstatisfied, resources);
        ProvisionLogger.LOGGER.debugf("END findResources", new Object[0]);
        ProvisionLogger.LOGGER.debugf("  resources: %s", result.getResources());
        ProvisionLogger.LOGGER.debugf("  unsatisfied: %s", result.getUnsatisfiedRequirements());
        ArrayList<XResource> mandatory = new ArrayList<XResource>();
        mandatory.addAll(resources);
        try {
            XResolveContext context = this.resolver.createResolveContext(envclone, mandatory, null);
            this.resolver.resolve((ResolveContext)context).entrySet();
        }
        catch (ResolutionException ex) {
            ProvisionLogger.LOGGER.cannotResolveResultResources(ex);
        }
        return result;
    }

    private void findResources(XEnvironment env, List<XResource> unresolved, Map<XRequirement, XResource> mapping, Set<XRequirement> unstatisfied, List<XResource> resources) {
        this.resolveInEnvironment(env, unresolved, mapping, unstatisfied, resources);
        if (unstatisfied.isEmpty()) {
            return;
        }
        boolean envModified = false;
        HashSet<XResource> installable = new HashSet<XResource>();
        ProvisionLogger.LOGGER.debugf("Finding unsatisfied reqs", new Object[0]);
        Iterator<XRequirement> itun = unstatisfied.iterator();
        while (itun.hasNext()) {
            XCapability cap;
            XRequirement req = itun.next();
            String reqnamespace = req.getNamespace();
            if (!env.findProviders((Requirement)req).isEmpty() || (cap = this.findProviderInRepository(req)) == null) continue;
            XIdentityCapability icap = cap.getResource().getIdentityCapability();
            String icaptype = (String)icap.getAttribute("type");
            if ("abstract".equals(icaptype)) {
                XCapability mcap;
                Iterator capIt;
                XRequirement mreq;
                if (this.getRequirementDelegate(icap, "maven.identity") != null) {
                    mreq = this.getRequirementDelegate(icap, "maven.identity");
                    capIt = this.repository.findProviders((Requirement)mreq).iterator();
                    if (capIt.hasNext()) {
                        mcap = (XCapability)capIt.next();
                        icap = mcap.getResource().getIdentityCapability();
                    }
                } else if (this.getRequirementDelegate(icap, "module.identity") != null && (capIt = this.repository.findProviders((Requirement)(mreq = this.getRequirementDelegate(icap, "module.identity"))).iterator()).hasNext()) {
                    mcap = (XCapability)capIt.next();
                    icap = mcap.getResource().getIdentityCapability();
                }
                itun.remove();
            } else if ("maven.identity".equals(reqnamespace)) {
                itun.remove();
            }
            installable.add(icap.getResource());
        }
        for (XResource res : installable) {
            if (resources.contains(res)) continue;
            Collection<XRequirement> reqs = this.getRequirements(res, null);
            Iterator<XRequirement> itreqs = reqs.iterator();
            while (itreqs.hasNext()) {
                XRequirement req = itreqs.next();
                boolean dynamic = "dynamic".equals(req.getDirective("resolution"));
                boolean optional = "optional".equals(req.getDirective("resolution"));
                if (!dynamic && !optional && env.findProviders((Requirement)req).size() <= 0) continue;
                itreqs.remove();
            }
            ProvisionLogger.LOGGER.debugf("Adding %d unsatisfied reqs", reqs.size());
            unstatisfied.addAll(reqs);
            env.installResources(new XResource[]{res});
            resources.add(res);
            envModified = true;
        }
        if (envModified) {
            this.findResources(env, unresolved, mapping, unstatisfied, resources);
        }
    }

    private Collection<XRequirement> getRequirements(XResource res, String[] namespaces) {
        HashSet<XRequirement> reqs = new HashSet<XRequirement>();
        if (namespaces != null) {
            for (String ns : namespaces) {
                for (Requirement req : res.getRequirements(ns)) {
                    reqs.add((XRequirement)req);
                }
            }
        } else {
            for (Requirement req : res.getRequirements(null)) {
                reqs.add((XRequirement)req);
            }
        }
        return reqs;
    }

    private XRequirement getRequirementDelegate(XIdentityCapability icap, String namespace) {
        List mreqs = icap.getResource().getRequirements(namespace);
        return (XRequirement)(mreqs.size() == 1 ? (Requirement)mreqs.get(0) : null);
    }

    private XCapability findProviderInRepository(XRequirement req) {
        ProvisionLogger.LOGGER.debugf("Find in repository: %s", req);
        ArrayList providers = this.repository.findProviders((Requirement)req);
        if (providers.size() > 1) {
            providers = new ArrayList(providers);
            Iterator itcap = providers.iterator();
            while (itcap.hasNext()) {
                XCapability cap = (XCapability)itcap.next();
                if (!cap.getResource().isAbstract()) continue;
                itcap.remove();
            }
        }
        XCapability cap = null;
        if (providers.size() == 1) {
            cap = (XCapability)providers.iterator().next();
            ProvisionLogger.LOGGER.debugf(" Found one: %s", cap);
        } else if (providers.size() > 1) {
            ArrayList sorted = new ArrayList(providers);
            Collections.sort(sorted, new Comparator<Capability>(){

                @Override
                public int compare(Capability cap1, Capability cap2) {
                    XIdentityCapability icap1 = ((XResource)cap1.getResource()).getIdentityCapability();
                    XIdentityCapability icap2 = ((XResource)cap2.getResource()).getIdentityCapability();
                    Version v1 = icap1.getVersion();
                    Version v2 = icap2.getVersion();
                    return v2.compareTo(v1);
                }
            });
            ProvisionLogger.LOGGER.debugf(" Found multiple: %s", sorted);
            cap = (XCapability)sorted.get(0);
        } else {
            ProvisionLogger.LOGGER.debugf(" Not found: %s", req);
        }
        return cap;
    }

    private void resolveInEnvironment(XEnvironment env, List<XResource> unresolved, Map<XRequirement, XResource> mapping, Set<XRequirement> unstatisfied, List<XResource> resources) {
        ArrayList<XResource> mandatory = new ArrayList<XResource>();
        mandatory.addAll(unresolved);
        mandatory.addAll(resources);
        try {
            XResolveContext context = this.resolver.createResolveContext(env, mandatory, null);
            Set wiremap = this.resolver.resolve((ResolveContext)context).entrySet();
            for (Map.Entry entry : wiremap) {
                for (XRequirement req : unstatisfied) {
                    for (Wire wire : (List)entry.getValue()) {
                        if (wire.getRequirement() != req) continue;
                        XResource provider = (XResource)wire.getProvider();
                        mapping.put(req, provider);
                    }
                }
            }
            unstatisfied.clear();
        }
        catch (ResolutionException ex) {
            for (Requirement req : ex.getUnresolvedRequirements()) {
                ProvisionLogger.LOGGER.debugf(" unresolved: %s", req);
            }
        }
    }

    private XEnvironment cloneEnvironment(XEnvironment env) {
        if (env instanceof AbstractEnvironment) {
            return ((AbstractEnvironment)env).clone();
        }
        AbstractEnvironment clone = new AbstractEnvironment();
        Iterator itres = env.getResources(null);
        while (itres.hasNext()) {
            clone.installResources(new XResource[]{(XResource)itres.next()});
        }
        return clone;
    }

    static class AbstractProvisionResult
    implements ProvisionResult {
        private final Map<XRequirement, XResource> mapping;
        private final Set<XRequirement> unsatisfied;
        private final List<XResource> resources;

        public AbstractProvisionResult(Map<XRequirement, XResource> mapping, Set<XRequirement> unstatisfied, List<XResource> resources) {
            this.mapping = mapping;
            this.unsatisfied = unstatisfied;
            this.resources = resources;
        }

        @Override
        public Map<XRequirement, XResource> getRequirementMapping() {
            return Collections.unmodifiableMap(this.mapping);
        }

        @Override
        public List<XResource> getResources() {
            return Collections.unmodifiableList(this.resources);
        }

        @Override
        public Set<XRequirement> getUnsatisfiedRequirements() {
            return Collections.unmodifiableSet(this.unsatisfied);
        }
    }
}

