/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.provision;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.osgi.provision.ProvisionLogger;
import org.jboss.osgi.provision.ProvisionMessages;
import org.jboss.osgi.provision.ProvisionResult;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.RepositoryReader;
import org.jboss.osgi.repository.RepositoryStorage;
import org.jboss.osgi.repository.RepositoryXMLReader;
import org.jboss.osgi.repository.ResourceInstaller;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XRequirementBuilder;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.resource.Requirement;

public class ProvisionerSupport {
    private final BundleContext syscontext;
    private final ResourceInstaller installer;
    private final XResourceProvisioner provisioner;
    private final XEnvironment environment;

    public ProvisionerSupport(BundleContext syscontext) {
        this.syscontext = syscontext;
        this.installer = (ResourceInstaller)syscontext.getService(syscontext.getServiceReference(ResourceInstaller.class));
        this.provisioner = (XResourceProvisioner)syscontext.getService(syscontext.getServiceReference(XResourceProvisioner.class));
        this.environment = (XEnvironment)syscontext.getService(syscontext.getServiceReference(XEnvironment.class));
    }

    public XEnvironment getEnvironment() {
        return this.environment;
    }

    public XResourceProvisioner getResourceProvisioner() {
        return this.provisioner;
    }

    public XRepository getRepository() {
        return this.provisioner.getRepository();
    }

    public List<ResourceHandle> installCapabilities(String namespace, String ... features) throws Exception {
        if (namespace == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("namespace");
        }
        if (features == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("features");
        }
        XRequirement[] reqs = new XRequirement[features.length];
        for (int i = 0; i < features.length; ++i) {
            reqs[i] = XRequirementBuilder.create((String)namespace, (String)features[i]).getRequirement();
        }
        return this.installCapabilities(reqs);
    }

    public List<ResourceHandle> installCapabilities(XRequirement ... reqs) throws Exception {
        XBundle bundle2;
        if (reqs == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("reqs");
        }
        ProvisionResult result = this.provisioner.findResources(this.environment, new HashSet<XRequirement>(Arrays.asList(reqs)));
        Set<XRequirement> unsat = result.getUnsatisfiedRequirements();
        if (!unsat.isEmpty()) {
            throw ProvisionMessages.MESSAGES.unsatiesfiedRequirements(unsat);
        }
        ArrayList<ResourceHandle> reshandles = new ArrayList<ResourceHandle>();
        for (XResource res : result.getResources()) {
            bundle2 = this.installer.installResource(this.syscontext, res);
            ResourceHandle handle = new ResourceHandle((Bundle)bundle2){
                final /* synthetic */ Bundle val$bundle;
                {
                    this.val$bundle = bundle2;
                }

                @Override
                public <T> T adapt(Class<T> type) {
                    return (T)(type == Bundle.class ? this.val$bundle : null);
                }

                @Override
                public void uninstall() {
                    try {
                        this.val$bundle.uninstall();
                    }
                    catch (Exception ex) {
                        ProvisionLogger.LOGGER.warnf(ex, "Cannot uninstall bundle: %s", this.val$bundle);
                    }
                }
            };
            reshandles.add(handle);
        }
        for (ResourceHandle handle : reshandles) {
            bundle2 = handle.adapt(Bundle.class);
            bundle2.start();
        }
        return reshandles;
    }

    public void populateRepository(ClassLoader classLoader, String ... features) throws IOException {
        if (features == null) {
            throw ProvisionMessages.MESSAGES.illegalArgumentNull("features");
        }
        for (String feature : features) {
            InputStream input = this.getFeatureResource(classLoader, feature);
            if (input == null) continue;
            RepositoryReader reader = RepositoryXMLReader.create((InputStream)input);
            XResource auxres = reader.nextResource();
            while (auxres != null) {
                XIdentityCapability icap = auxres.getIdentityCapability();
                String nsvalue = (String)icap.getAttribute(icap.getNamespace());
                XRequirement ireq = XRequirementBuilder.create((String)icap.getNamespace(), (String)nsvalue).getRequirement();
                RepositoryStorage storage = (RepositoryStorage)this.getRepository().adapt(RepositoryStorage.class);
                if (storage.findProviders((Requirement)ireq).isEmpty()) {
                    storage.addResource(auxres);
                }
                auxres = reader.nextResource();
            }
        }
    }

    private InputStream getFeatureResource(ClassLoader classLoader, String feature) {
        return classLoader.getResourceAsStream("/repository/" + feature + ".xml");
    }

    public static interface ResourceHandle {
        public <T> T adapt(Class<T> var1);

        public void uninstall();
    }
}

