/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.provision.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.jboss.osgi.provision.AbstractResourceProvisioner;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceProvisionerActivator
implements BundleActivator {
    private ServiceTracker<XResolver, XResolver> resolverTracker;
    private ServiceTracker<XRepository, XRepository> repositoryTracker;
    private List<ServiceRegistration<?>> registrations = new ArrayList();

    public void start(BundleContext context) throws Exception {
        this.resolverTracker = new ServiceTracker<XResolver, XResolver>(context, XResolver.class, null){

            public XResolver addingService(ServiceReference<XResolver> reference) {
                XResolver resolver = (XResolver)super.addingService(reference);
                ResourceProvisionerActivator.this.createProvisionService(this.context, resolver, (XRepository)ResourceProvisionerActivator.this.repositoryTracker.getService());
                return resolver;
            }
        };
        this.repositoryTracker = new ServiceTracker<XRepository, XRepository>(context, XRepository.class, null){

            public XRepository addingService(ServiceReference<XRepository> reference) {
                XRepository repository = (XRepository)super.addingService(reference);
                ResourceProvisionerActivator.this.createProvisionService(this.context, (XResolver)ResourceProvisionerActivator.this.resolverTracker.getService(), repository);
                return repository;
            }
        };
        this.resolverTracker.open();
        this.repositoryTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.resolverTracker != null) {
            this.resolverTracker.close();
        }
        if (this.repositoryTracker != null) {
            this.repositoryTracker.close();
        }
        for (ServiceRegistration<?> reg : this.registrations) {
            reg.unregister();
        }
    }

    private void createProvisionService(BundleContext context, XResolver resolver, XRepository repository) {
        if (resolver != null && repository != null) {
            AbstractResourceProvisioner provisioner = new AbstractResourceProvisioner(resolver, repository);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("type", "osgi.bundle");
            this.registrations.add(context.registerService(XResourceProvisioner.class, (Object)provisioner, props));
        }
    }
}

