/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.provision.AbstractResourceProvisioner;
import org.jboss.osgi.provision.XResourceProvisioner;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.resolver.XResolver;

public final class ResourceProvisionerService
extends AbstractService<XResourceProvisioner> {
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<XPersistentRepository> injectedRepository = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private ModelControllerClient modelControllerClient;
    private XResourceProvisioner provisioner;

    public static ServiceController<?> addService(ServiceTarget target) {
        ResourceProvisionerService service = new ResourceProvisionerService();
        ServiceBuilder builder = target.addService(OSGiConstants.PROVISIONER_SERVICE_NAME, (Service)service);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.injectedController);
        builder.addDependency(OSGiConstants.REPOSITORY_SERVICE_NAME, XPersistentRepository.class, service.injectedRepository);
        builder.addDependency(OSGiConstants.RESOLVER_SERVICE_NAME, XResolver.class, service.injectedResolver);
        return builder.install();
    }

    private ResourceProvisionerService() {
    }

    public void start(StartContext startContext) throws StartException {
        ModelController modelController = (ModelController)this.injectedController.getValue();
        this.modelControllerClient = modelController.createClient((Executor)Executors.newCachedThreadPool());
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        XPersistentRepository repository = (XPersistentRepository)this.injectedRepository.getValue();
        this.provisioner = new AbstractResourceProvisioner(resolver, (XRepository)repository);
    }

    public synchronized void stop(StopContext context) {
        try {
            this.modelControllerClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized XResourceProvisioner getValue() throws IllegalStateException {
        return this.provisioner;
    }
}

