/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

@Provider
@ApplicationPath(value="/")
public class TestApplication
extends Application {
    public static Set<Class<?>> classes = new HashSet();
    public static Set<Object> singletons = new HashSet<Object>();

    public static String[] getClassesFromDeployment(String name) {
        String resource = name + ".txt";
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = TestApplication.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = TestApplication.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            return new String[0];
        }
        return TestApplication.convertStreamToString(stream).split(",");
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public Set<Class<?>> getClasses() {
        if (classes.isEmpty()) {
            for (String clazz : TestApplication.getClassesFromDeployment("classes")) {
                if (clazz.isEmpty()) continue;
                try {
                    classes.add(Class.forName(clazz));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class " + clazz + " not found.", e);
                }
            }
        }
        return classes;
    }

    public Set<Object> getSingletons() {
        if (singletons.isEmpty()) {
            for (String clazz : TestApplication.getClassesFromDeployment("singletons")) {
                if (clazz.isEmpty()) continue;
                try {
                    singletons.add(Class.forName(clazz).newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException("Class " + clazz + " not found.", e);
                }
            }
        }
        return singletons;
    }
}

