/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.setup;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.arquillian.setup.ReloadServerSetupTask;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public abstract class AbstractUsersRolesSecurityDomainSetup
extends ReloadServerSetupTask
implements ServerSetupTask {
    private static final String USERS_FILENAME = "users.properties";
    private static final String ROLES_FILENAME = "roles.properties";
    private final URL userFile;
    private final URL rolesFile;
    private final Deque<ModelNode> toRemove;
    private final Queue<Path> filesToRemove;

    protected AbstractUsersRolesSecurityDomainSetup(URL userFile, URL rolesFile) {
        this.userFile = userFile;
        this.rolesFile = rolesFile;
        this.toRemove = new LinkedList<ModelNode>();
        this.filesToRemove = new ArrayDeque<Path>();
    }

    public void doSetup(ManagementClient client, String s) throws Exception {
        ModelNode address = Operations.createAddress((String[])new String[]{"path", "jboss.server.config.dir"});
        ModelNode op = Operations.createReadAttributeOperation((ModelNode)address, (String)"path");
        Path configDir = Path.of(this.executeOperation(client, op).asString(), new String[0]);
        this.filesToRemove.add(this.createPropertiesFile(this.userFile, configDir.resolve(USERS_FILENAME)));
        this.filesToRemove.add(this.createPropertiesFile(this.rolesFile, configDir.resolve(ROLES_FILENAME)));
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        for (Map.Entry<String, String> entry : this.getSecurityDomainConfig().entrySet()) {
            String domainName = entry.getKey();
            String realmName = entry.getValue();
            address = Operations.createAddress((String[])new String[]{"subsystem", "elytron", "properties-realm", realmName});
            op = Operations.createAddOperation((ModelNode)address);
            ModelNode userProperties = op.get("users-properties").setEmptyObject();
            userProperties.get("path").set(USERS_FILENAME);
            userProperties.get("relative-to").set("jboss.server.config.dir");
            userProperties.get("plain-text").set(true);
            ModelNode groupProperties = op.get("groups-properties").setEmptyObject();
            groupProperties.get("path").set(ROLES_FILENAME);
            groupProperties.get("relative-to").set("jboss.server.config.dir");
            builder.addStep(op);
            this.toRemove.addLast(address);
            address = Operations.createAddress((String[])new String[]{"subsystem", "elytron", "security-domain", domainName});
            op = Operations.createAddOperation((ModelNode)address);
            ModelNode realms = new ModelNode().setEmptyObject();
            realms.get("realm").set(realmName);
            realms.get("role-decoder").set("groups-to-roles");
            op.get("realms").setEmptyList().add(realms);
            op.get("default-realm").set(realmName);
            op.get("permission-mapper").set("default-permission-mapper");
            builder.addStep(op);
            this.toRemove.addFirst(address);
            address = Operations.createAddress((String[])new String[]{"subsystem", "elytron", "http-authentication-factory", "http-auth-" + domainName});
            op = Operations.createAddOperation((ModelNode)address);
            ModelNode mechanismConfigs = new ModelNode().setEmptyObject();
            mechanismConfigs.get("mechanism-name").set("BASIC");
            ModelNode mechanisms = mechanismConfigs.get("mechanism-realm-configurations").setEmptyList();
            ModelNode mechanismsValue = new ModelNode().setEmptyObject();
            mechanismsValue.get("realm-name").set("propRealm");
            mechanisms.add(mechanismsValue);
            op.get("mechanism-configurations").setEmptyList().add(mechanismConfigs);
            op.get("http-server-mechanism-factory").set("global");
            op.get("security-domain").set(domainName);
            builder.addStep(op);
            this.toRemove.addFirst(address);
            address = Operations.createAddress((String[])new String[]{"subsystem", "undertow", "application-security-domain", domainName});
            op = Operations.createAddOperation((ModelNode)address);
            op.get("http-authentication-factory").set("http-auth-" + domainName);
            builder.addStep(op);
            this.toRemove.addFirst(address);
        }
        this.executeOperation(client, builder.build());
    }

    public void doTearDown(ManagementClient client, String s) throws Exception {
        Path file;
        ModelNode address;
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        while ((address = this.toRemove.pollFirst()) != null) {
            builder.addStep(Operations.createRemoveOperation((ModelNode)address));
        }
        this.executeOperation(client, builder.build());
        while ((file = this.filesToRemove.poll()) != null) {
            Files.deleteIfExists(file);
        }
    }

    public Map<String, String> getSecurityDomainConfig() {
        return Collections.singletonMap("jaxrsSecDomain", "propRealm");
    }

    private Path createPropertiesFile(URL url, Path file) throws IOException {
        if (url != null) {
            try (InputStream in = url.openStream();){
                Files.copy(in, file, StandardCopyOption.REPLACE_EXISTING);
            }
        } else if (Files.notExists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        return file;
    }
}

