/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.engines.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;

public class ReactorNettyClientHttpEngine
implements AsyncClientHttpEngine {
    private static final Logger log = LoggerFactory.getLogger(ReactorNettyClientHttpEngine.class);
    private final HttpClient httpClient;
    private final ChannelGroup channelGroup;
    private final ConnectionProvider connectionProvider;

    public ReactorNettyClientHttpEngine(HttpClient httpClient, ChannelGroup channelGroup, ConnectionProvider connectionProvider) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.channelGroup = Objects.requireNonNull(channelGroup);
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
    }

    public <T> Future<T> submit(ClientInvocation request, boolean buffered, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        return this.submit(request, buffered, extractor, null).whenComplete((response, throwable) -> {
            if (callback != null) {
                if (throwable != null) {
                    callback.failed(throwable);
                } else {
                    callback.completed(response);
                }
            }
        });
    }

    public <T> CompletableFuture<T> submit(ClientInvocation request, boolean buffered, AsyncClientHttpEngine.ResultExtractor<T> extractor, ExecutorService executorService) {
        Optional<byte[]> payload = Optional.ofNullable(request.getEntity()).map(entity -> ReactorNettyClientHttpEngine.requestContent(request));
        HttpClient.RequestSender requestSender = (HttpClient.RequestSender)this.httpClient.headers(headerBuilder -> {
            ClientRequestHeaders resteasyHeaders = request.getHeaders();
            resteasyHeaders.getHeaders().entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                List valueList = (List)entry.getValue();
                valueList.forEach(value -> headerBuilder.add(key, value != null ? value : ""));
            });
            payload.ifPresent(bytes -> {
                headerBuilder.set("Content-Length", (Object)((byte[])bytes).length);
                if (log.isDebugEnabled() && ReactorNettyClientHttpEngine.isContentLengthInvalid(resteasyHeaders.getHeader("Content-Length"), bytes)) {
                    log.debug("The request's Content-Length header is replaced  by the size of the byte array computed from the request entity.");
                }
            });
        }).request(HttpMethod.valueOf((String)request.getMethod())).uri(request.getUri().toString());
        HttpClient.ResponseReceiver responseReceiver = payload.map(bytes -> requestSender.send((httpClientRequest, outbound) -> outbound.sendObject((Publisher)Mono.just((Object)outbound.alloc().buffer().writeBytes(bytes))))).orElse((HttpClient.ResponseReceiver)requestSender);
        return responseReceiver.responseSingle((response, bytes) -> bytes.asInputStream().map(is -> this.extractResult(request.getClientConfiguration(), (HttpClientResponse)response, (InputStream)is, extractor)).switchIfEmpty(Mono.defer(() -> Mono.just(this.extractResult(request.getClientConfiguration(), (HttpClientResponse)response, null, extractor))))).toFuture();
    }

    private static boolean isContentLengthInvalid(String headerValue, byte[] payload) {
        try {
            return headerValue != null && Long.parseLong(headerValue) != (long)payload.length;
        }
        catch (Exception e) {
            log.warn("Problem parsing the Content-Length header value.", (Throwable)e);
            return true;
        }
    }

    public SSLContext getSslContext() {
        throw new UnsupportedOperationException();
    }

    public HostnameVerifier getHostnameVerifier() {
        throw new UnsupportedOperationException();
    }

    public Response invoke(Invocation request) {
        Future future = this.submit((ClientInvocation)request, false, null, response -> response);
        try {
            return (Response)future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw ReactorNettyClientHttpEngine.clientException(e, null);
        }
        catch (ExecutionException e) {
            throw ReactorNettyClientHttpEngine.clientException(e.getCause(), null);
        }
    }

    public void close() {
        try {
            this.channelGroup.close().await();
        }
        catch (InterruptedException e) {
            log.warn("Exception while closing Netty ChannelGroup", (Throwable)e);
        }
        finally {
            this.connectionProvider.disposeLater().block();
        }
    }

    static RuntimeException clientException(Throwable ex, Response clientResponse) {
        Object ret = ex == null ? new ProcessingException((Throwable)new NullPointerException()) : (ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : (clientResponse != null ? new ResponseProcessingException(clientResponse, ex) : new ProcessingException(ex))));
        return ret;
    }

    private static byte[] requestContent(ClientInvocation request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.getDelegatingOutputStream().setDelegate((OutputStream)baos);
        try {
            request.writeRequestBody(request.getEntityStream());
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write the request body!", e);
        }
    }

    private <T> T extractResult(ClientConfiguration clientConfiguration, HttpClientResponse reactorNettyResponse, InputStream inputStream, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        return (T)extractor.extractResult(this.toRestEasyResponse(clientConfiguration, reactorNettyResponse, inputStream));
    }

    private ClientResponse toRestEasyResponse(ClientConfiguration clientConfiguration, HttpClientResponse reactorNettyResponse, InputStream inputStream) {
        class RestEasyClientResponse
        extends ClientResponse {
            private InputStream is;

            RestEasyClientResponse(ClientConfiguration configuration, InputStream is) {
                super(configuration, RESTEasyTracingLogger.empty());
                this.is = is;
            }

            protected InputStream getInputStream() {
                return this.is;
            }

            protected void setInputStream(InputStream inputStream) {
                this.is = inputStream;
            }

            public void releaseConnection() throws IOException {
                this.releaseConnection(false);
            }

            public void releaseConnection(boolean consumeInputStream) throws IOException {
                try {
                    if (this.is != null) {
                        if (consumeInputStream) {
                            while (this.is.available() > 0) {
                                this.is.read();
                            }
                        }
                        this.is.close();
                    }
                }
                catch (IOException e) {
                    log.warn("Exception while releasing the connection!", (Throwable)e);
                }
            }
        }
        RestEasyClientResponse restEasyClientResponse = new RestEasyClientResponse(clientConfiguration, inputStream);
        restEasyClientResponse.setStatus(reactorNettyResponse.status().code());
        MultivaluedMap resteasyHeaders = restEasyClientResponse.getHeaders();
        reactorNettyResponse.responseHeaders().forEach(header -> resteasyHeaders.add(header.getKey(), header.getValue()));
        return restEasyClientResponse;
    }
}

