/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.HeaderDecoratorPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.annotations.security.doseta.After;
import org.jboss.resteasy.annotations.security.doseta.Verifications;
import org.jboss.resteasy.annotations.security.doseta.Verify;
import org.jboss.resteasy.security.doseta.Verification;
import org.jboss.resteasy.security.doseta.Verifier;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.MessageBodyReaderContext;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
@HeaderDecoratorPrecedence
public class DigitalVerificationHeaderDecorator
implements MessageBodyReaderInterceptor,
AcceptedByMethod {
    protected Verify verify;
    protected Verifications verifications;

    public boolean accept(Class declaring, Method method) {
        this.verify = method.getAnnotation(Verify.class);
        this.verifications = method.getAnnotation(Verifications.class);
        return this.verify != null || this.verifications != null;
    }

    public Object read(MessageBodyReaderContext context) throws IOException, WebApplicationException {
        Verifier verifier = new Verifier();
        if (this.verify != null) {
            Verification v = this.createVerification(this.verify);
            verifier.getVerifications().add(v);
        }
        if (this.verifications != null) {
            for (Verify ver : this.verifications.value()) {
                Verification v = this.createVerification(ver);
                verifier.getVerifications().add(v);
            }
        }
        context.setAttribute(Verifier.class.getName(), (Object)verifier);
        return context.proceed();
    }

    protected Verification createVerification(Verify v) {
        Verification verification = new Verification();
        if (v.identifierName() != null && !v.identifierName().trim().equals("")) {
            verification.setIdentifierName(v.identifierName());
        }
        if (v.identifierValue() != null && !v.identifierValue().trim().equals("")) {
            verification.setIdentifierValue(v.identifierValue());
        }
        verification.setIgnoreExpiration(v.ignoreExpiration());
        After staleAfter = v.stale();
        if (staleAfter.seconds() > 0 || staleAfter.minutes() > 0 || staleAfter.hours() > 0 || staleAfter.days() > 0 || staleAfter.months() > 0 || staleAfter.years() > 0) {
            verification.setStaleCheck(true);
            verification.setStaleSeconds(staleAfter.seconds());
            verification.setStaleMinutes(staleAfter.minutes());
            verification.setStaleHours(staleAfter.hours());
            verification.setStaleDays(staleAfter.days());
            verification.setStaleMonths(staleAfter.months());
            verification.setStaleYears(staleAfter.years());
        }
        return verification;
    }
}

